;;; typst-ts-symbols.el --- Symbol and Emoji menu -*- lexical-binding: t; -*-
;; Copyright (C) 2023-2024 The typst-ts-mode Project Contributors

;; This file is NOT part of Emacs.
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;;; Code:

(defcustom typst-ts-symbol-alist
  '(("wj" . "wjoin") ("zwj" . "zwj") ("zwnj" . "zwnj") ("zws" . "zwsp")
    ("lrm" . "‎") ("rlm" . "‏") ("space" . "␣")
    ("space.nobreak" . "nbsp") ("space.nobreak.narrow" . " ")
    ("space.en" . "ensp") ("space.quad" . "emsp")
    ("space.third" . "⅓emsp") ("space.quarter" . "¼emsp")
    ("space.sixth" . "⅙emsp") ("space.med" . "mmsp")
    ("space.fig" . "numsp") ("space.punct" . "puncsp")
    ("space.thin" . "thinsp") ("space.hair" . "hairsp") ("paren.l" . "(")
    ("paren.l.double" . "⦅") ("paren.r" . ")") ("paren.r.double" . "⦆")
    ("paren.t" . "⏜") ("paren.b" . "⏝") ("brace.l" . "{")
    ("brace.l.double" . "⦃") ("brace.r" . "}") ("brace.r.double" . "⦄")
    ("brace.t" . "⏞") ("brace.b" . "⏟") ("bracket.l" . "[")
    ("bracket.l.double" . "⟦") ("bracket.r" . "]")
    ("bracket.r.double" . "⟧") ("bracket.t" . "⎴") ("bracket.b" . "⎵")
    ("shell.l" . "❲") ("shell.l.double" . "⟬") ("shell.r" . "❳")
    ("shell.r.double" . "⟭") ("shell.t" . "⏠") ("shell.b" . "⏡")
    ("bar.v" . "|") ("bar.v.double" . "‖") ("bar.v.triple" . "⦀")
    ("bar.v.broken" . "¦") ("bar.v.circle" . "⦶") ("bar.h" . "―")
    ("fence.l" . "⧘") ("fence.l.double" . "⧚") ("fence.r" . "⧙")
    ("fence.r.double" . "⧛") ("fence.dotted" . "⦙") ("angle" . "∠")
    ("angle.l" . "⟨") ("angle.l.curly" . "⧼") ("angle.l.dot" . "⦑")
    ("angle.l.double" . "《") ("angle.r" . "⟩") ("angle.r.curly" . "⧽")
    ("angle.r.dot" . "⦒") ("angle.r.double" . "》") ("angle.acute" . "⦟")
    ("angle.arc" . "∡") ("angle.arc.rev" . "⦛") ("angle.oblique" . "⦦")
    ("angle.rev" . "⦣") ("angle.right" . "∟") ("angle.right.rev" . "⯾")
    ("angle.right.arc" . "⊾") ("angle.right.dot" . "⦝")
    ("angle.right.sq" . "⦜") ("angle.s" . "⦞") ("angle.spatial" . "⟀")
    ("angle.spheric" . "∢") ("angle.spheric.rev" . "⦠")
    ("angle.spheric.top" . "⦡") ("ceil.l" . "⌈") ("ceil.r" . "⌉")
    ("floor.l" . "⌊") ("floor.r" . "⌋") ("amp" . "&") ("amp.inv" . "⅋")
    ("ast.op" . "∗") ("ast.basic" . "*") ("ast.low" . "⁎")
    ("ast.double" . "⁑") ("ast.triple" . "⁂") ("ast.small" . "﹡")
    ("ast.circle" . "⊛") ("ast.square" . "⧆") ("at" . "@")
    ("backslash" . "\\") ("backslash.circle" . "⦸")
    ("backslash.not" . "⧷") ("co" . "℅") ("colon" . ":")
    ("colon.double" . "∷") ("colon.eq" . "≔") ("colon.double.eq" . "⩴")
    ("comma" . " .") ("dagger" . "†") ("dagger.double" . "‡")
    ("dash.en" . "–") ("dash.em" . "—") ("dash.em.two" . "⸺")
    ("dash.em.three" . "⸻") ("dash.fig" . "‒") ("dash.wave" . "〜")
    ("dash.colon" . "∹") ("dash.circle" . "⊝")
    ("dash.wave.double" . "〰") ("dot.op" . "⋅") ("dot.basic" . ".")
    ("dot.c" . "·") ("dot.circle" . "⊙") ("dot.circle.big" . "⨀")
    ("dot.square" . "⊡") ("dot.double" . "¨") ("dot.triple" . "⃛")
    ("dot.quad" . "⃜") ("excl" . "!") ("excl.double" . "‼")
    ("excl.inv" . "¡") ("excl.quest" . "⁉") ("quest" . "?")
    ("quest.double" . "⁇") ("quest.excl" . "⁈") ("quest.inv" . "¿")
    ("interrobang" . "‽") ("hash" . "#") ("hyph" . "‐")
    ("hyph.minus" . "-") ("hyph.nobreak" . "‑") ("hyph.point" . "‧")
    ("hyph.soft" . "shy") ("percent" . "%") ("permille" . "‰")
    ("pilcrow" . "¶") ("pilcrow.rev" . "⁋") ("section" . "§")
    ("semi" . ";") ("semi.rev" . "⁏") ("slash" . "/")
    ("slash.double" . "⫽") ("slash.triple" . "⫻") ("slash.big" . "⧸")
    ("dots.h.c" . "⋯") ("dots.h" . "…") ("dots.v" . "⋮")
    ("dots.down" . "⋱") ("dots.up" . "⋰") ("tilde.op" . "∼")
    ("tilde.basic" . "~") ("tilde.dot" . "⩪") ("tilde.eq" . "≃")
    ("tilde.eq.not" . "≄") ("tilde.eq.rev" . "⋍") ("tilde.equiv" . "≅")
    ("tilde.equiv.not" . "≇") ("tilde.nequiv" . "≆") ("tilde.not" . "≁")
    ("tilde.rev" . "∽") ("tilde.rev.equiv" . "≌") ("tilde.triple" . "≋")
    ("acute" . "´") ("acute.double" . "˝") ("breve" . "˘")
    ("caret" . "‸") ("caron" . "ˇ") ("hat" . "^") ("diaer" . "¨")
    ("grave" . "`") ("macron" . "¯") ("quote.double" . "\"")
    ("quote.single" . "'") ("quote.l.double" . "“")
    ("quote.l.single" . "‘") ("quote.r.double" . "”")
    ("quote.r.single" . "’") ("quote.angle.l.double" . "«")
    ("quote.angle.l.single" . "‹") ("quote.angle.r.double" . "»")
    ("quote.angle.r.single" . "›") ("quote.high.double" . "‟")
    ("quote.high.single" . "‛") ("quote.low.double" . "„")
    ("quote.low.single" . "‚") ("prime" . "′") ("prime.rev" . "‵")
    ("prime.double" . "″") ("prime.double.rev" . "‶")
    ("prime.triple" . "‴") ("prime.triple.rev" . "‷")
    ("prime.quad" . "⁗") ("plus" . "+") ("plus.circle" . "⊕")
    ("plus.circle.arrow" . "⟴") ("plus.circle.big" . "⨁")
    ("plus.dot" . "∔") ("plus.double" . "⧺") ("plus.minus" . "±")
    ("plus.small" . "﹢") ("plus.square" . "⊞") ("plus.triangle" . "⨹")
    ("plus.triple" . "⧻") ("minus" . "−") ("minus.circle" . "⊖")
    ("minus.dot" . "∸") ("minus.plus" . "∓") ("minus.square" . "⊟")
    ("minus.tilde" . "≂") ("minus.triangle" . "⨺") ("div" . "÷")
    ("div.circle" . "⨸") ("times" . "×") ("times.big" . "⨉")
    ("times.circle" . "⊗") ("times.circle.big" . "⨂") ("times.div" . "⋇")
    ("times.three.l" . "⋋") ("times.three.r" . "⋌") ("times.l" . "⋉")
    ("times.r" . "⋊") ("times.square" . "⊠") ("times.triangle" . "⨻")
    ("ratio" . "∶") ("eq" . "=") ("eq.star" . "≛") ("eq.circle" . "⊜")
    ("eq.colon" . "≕") ("eq.def" . "≝") ("eq.delta" . "≜")
    ("eq.equi" . "≚") ("eq.est" . "≙") ("eq.gt" . "⋝") ("eq.lt" . "⋜")
    ("eq.m" . "≞") ("eq.not" . "≠") ("eq.prec" . "⋞") ("eq.quest" . "≟")
    ("eq.small" . "﹦") ("eq.succ" . "⋟") ("eq.triple" . "≡")
    ("eq.quad" . "≣") ("gt" . ">") ("gt.circle" . "⧁") ("gt.dot" . "⋗")
    ("gt.approx" . "⪆") ("gt.double" . "≫") ("gt.eq" . "≥")
    ("gt.eq.slant" . "⩾") ("gt.eq.lt" . "⋛") ("gt.eq.not" . "≱")
    ("gt.equiv" . "≧") ("gt.lt" . "≷") ("gt.lt.not" . "≹")
    ("gt.neq" . "⪈") ("gt.napprox" . "⪊") ("gt.nequiv" . "≩")
    ("gt.not" . "≯") ("gt.ntilde" . "⋧") ("gt.small" . "﹥")
    ("gt.tilde" . "≳") ("gt.tilde.not" . "≵") ("gt.tri" . "⊳")
    ("gt.tri.eq" . "⊵") ("gt.tri.eq.not" . "⋭") ("gt.tri.not" . "⋫")
    ("gt.triple" . "⋙") ("gt.triple.nested" . "⫸") ("lt" . "<")
    ("lt.circle" . "⧀") ("lt.dot" . "⋖") ("lt.approx" . "⪅")
    ("lt.double" . "≪") ("lt.eq" . "≤") ("lt.eq.slant" . "⩽")
    ("lt.eq.gt" . "⋚") ("lt.eq.not" . "≰") ("lt.equiv" . "≦")
    ("lt.gt" . "≶") ("lt.gt.not" . "≸") ("lt.neq" . "⪇")
    ("lt.napprox" . "⪉") ("lt.nequiv" . "≨") ("lt.not" . "≮")
    ("lt.ntilde" . "⋦") ("lt.small" . "﹤") ("lt.tilde" . "≲")
    ("lt.tilde.not" . "≴") ("lt.tri" . "⊲") ("lt.tri.eq" . "⊴")
    ("lt.tri.eq.not" . "⋬") ("lt.tri.not" . "⋪") ("lt.triple" . "⋘")
    ("lt.triple.nested" . "⫷") ("approx" . "≈") ("approx.eq" . "≊")
    ("approx.not" . "≉") ("prec" . "≺") ("prec.approx" . "⪷")
    ("prec.curly.eq" . "≼") ("prec.curly.eq.not" . "⋠")
    ("prec.double" . "⪻") ("prec.eq" . "⪯") ("prec.equiv" . "⪳")
    ("prec.napprox" . "⪹") ("prec.neq" . "⪱") ("prec.nequiv" . "⪵")
    ("prec.not" . "⊀") ("prec.ntilde" . "⋨") ("prec.tilde" . "≾")
    ("succ" . "≻") ("succ.approx" . "⪸") ("succ.curly.eq" . "≽")
    ("succ.curly.eq.not" . "⋡") ("succ.double" . "⪼") ("succ.eq" . "⪰")
    ("succ.equiv" . "⪴") ("succ.napprox" . "⪺") ("succ.neq" . "⪲")
    ("succ.nequiv" . "⪶") ("succ.not" . "⊁") ("succ.ntilde" . "⋩")
    ("succ.tilde" . "≿") ("equiv" . "≡") ("equiv.not" . "≢")
    ("prop" . "∝") ("original" . "⊶") ("image" . "⊷") ("emptyset" . "∅")
    ("emptyset.arrow.r" . "⦳") ("emptyset.arrow.l" . "⦴")
    ("emptyset.bar" . "⦱") ("emptyset.circle" . "⦲")
    ("emptyset.rev" . "⦰") ("nothing" . "∅") ("nothing.arrow.r" . "⦳")
    ("nothing.arrow.l" . "⦴") ("nothing.bar" . "⦱")
    ("nothing.circle" . "⦲") ("nothing.rev" . "⦰") ("without" . "∖")
    ("complement" . "∁") ("in" . "∈") ("in.not" . "∉") ("in.rev" . "∋")
    ("in.rev.not" . "∌") ("in.rev.small" . "∍") ("in.small" . "∊")
    ("subset" . "⊂") ("subset.dot" . "⪽") ("subset.double" . "⋐")
    ("subset.eq" . "⊆") ("subset.eq.not" . "⊈") ("subset.eq.sq" . "⊑")
    ("subset.eq.sq.not" . "⋢") ("subset.neq" . "⊊") ("subset.not" . "⊄")
    ("subset.sq" . "⊏") ("subset.sq.neq" . "⋤") ("supset" . "⊃")
    ("supset.dot" . "⪾") ("supset.double" . "⋑") ("supset.eq" . "⊇")
    ("supset.eq.not" . "⊉") ("supset.eq.sq" . "⊒")
    ("supset.eq.sq.not" . "⋣") ("supset.neq" . "⊋") ("supset.not" . "⊅")
    ("supset.sq" . "⊐") ("supset.sq.neq" . "⋥") ("union" . "∪")
    ("union.arrow" . "⊌") ("union.big" . "⋃") ("union.dot" . "⊍")
    ("union.dot.big" . "⨃") ("union.double" . "⋓") ("union.minus" . "⩁")
    ("union.or" . "⩅") ("union.plus" . "⊎") ("union.plus.big" . "⨄")
    ("union.sq" . "⊔") ("union.sq.big" . "⨆") ("union.sq.double" . "⩏")
    ("sect" . "∩") ("sect.and" . "⩄") ("sect.big" . "⋂")
    ("sect.dot" . "⩀") ("sect.double" . "⋒") ("sect.sq" . "⊓")
    ("sect.sq.big" . "⨅") ("sect.sq.double" . "⩎") ("infinity" . "∞")
    ("infinity.bar" . "⧞") ("infinity.incomplete" . "⧜")
    ("infinity.tie" . "⧝") ("oo" . "∞") ("diff" . "∂") ("partial" . "∂")
    ("gradient" . "∇") ("nabla" . "∇") ("sum" . "∑")
    ("sum.integral" . "⨋") ("product" . "∏") ("product.co" . "∐")
    ("integral" . "∫") ("integral.arrow.hook" . "⨗")
    ("integral.ccw" . "⨑") ("integral.cont" . "∮")
    ("integral.cont.ccw" . "∳") ("integral.cont.cw" . "∲")
    ("integral.cw" . "∱") ("integral.dash" . "⨍")
    ("integral.dash.double" . "⨎") ("integral.double" . "∬")
    ("integral.quad" . "⨌") ("integral.sect" . "⨙")
    ("integral.slash" . "⨏") ("integral.square" . "⨖")
    ("integral.surf" . "∯") ("integral.times" . "⨘")
    ("integral.triple" . "∭") ("integral.union" . "⨚")
    ("integral.vol" . "∰") ("laplace" . "∆") ("forall" . "∀")
    ("exists" . "∃") ("exists.not" . "∄") ("top" . "⊤") ("bot" . "⊥")
    ("not" . "¬") ("and" . "∧") ("and.big" . "⋀") ("and.curly" . "⋏")
    ("and.dot" . "⟑") ("and.double" . "⩓") ("or" . "∨") ("or.big" . "⋁")
    ("or.curly" . "⋎") ("or.dot" . "⟇") ("or.double" . "⩔") ("xor" . "⊕")
    ("xor.big" . "⨁") ("models" . "⊧") ("forces" . "⊩")
    ("forces.not" . "⊮") ("therefore" . "∴") ("because" . "∵")
    ("qed" . "∎") ("compose" . "∘") ("convolve" . "∗") ("multimap" . "⊸")
    ("multimap.double" . "⧟") ("tiny" . "⧾") ("miny" . "⧿")
    ("divides" . "∣") ("divides.not" . "∤") ("wreath" . "≀")
    ("parallel" . "∥") ("parallel.struck" . "⫲")
    ("parallel.circle" . "⦷") ("parallel.eq" . "⋕")
    ("parallel.equiv" . "⩨") ("parallel.not" . "∦")
    ("parallel.slanted.eq" . "⧣") ("parallel.slanted.eq.tilde" . "⧤")
    ("parallel.slanted.equiv" . "⧥") ("parallel.tilde" . "⫳")
    ("perp" . "⟂") ("perp.circle" . "⦹") ("diameter" . "⌀")
    ("join" . "⨝") ("join.r" . "⟖") ("join.l" . "⟕") ("join.l.r" . "⟗")
    ("degree" . "°") ("degree.c" . "℃") ("degree.f" . "℉")
    ("smash" . "⨳") ("bitcoin" . "₿") ("dollar" . "$") ("euro" . "€")
    ("franc" . "₣") ("lira" . "₺") ("peso" . "₱") ("pound" . "£")
    ("ruble" . "₽") ("rupee" . "₹") ("won" . "₩") ("yen" . "¥")
    ("ballot" . "☐") ("ballot.cross" . "☒") ("ballot.check" . "☑")
    ("ballot.check.heavy" . "🗹") ("checkmark" . "✓")
    ("checkmark.light" . "🗸") ("checkmark.heavy" . "✔")
    ("crossmark" . "✗") ("crossmark.heavy" . "✘") ("floral" . "❦")
    ("floral.l" . "☙") ("floral.r" . "❧") ("refmark" . "※")
    ("copyright" . "©") ("copyright.sound" . "℗") ("copyleft" . "🄯")
    ("trademark" . "™") ("trademark.registered" . "®")
    ("trademark.service" . "℠") ("maltese" . "✠")
    ("suit.club.filled" . "♣") ("suit.club.stroked" . "♧")
    ("suit.diamond.filled" . "♦") ("suit.diamond.stroked" . "♢")
    ("suit.heart.filled" . "♥") ("suit.heart.stroked" . "♡")
    ("suit.spade.filled" . "♠") ("suit.spade.stroked" . "♤")
    ("note.up" . "🎜") ("note.down" . "🎝") ("note.whole" . "𝅝")
    ("note.half" . "𝅗𝅥") ("note.quarter" . "𝅘𝅥") ("note.quarter.alt" . "♩")
    ("note.eighth" . "𝅘𝅥𝅮") ("note.eighth.alt" . "♪")
    ("note.eighth.beamed" . "♫") ("note.sixteenth" . "𝅘𝅥𝅯")
    ("note.sixteenth.beamed" . "♬") ("note.grace" . "𝆕")
    ("note.grace.slash" . "𝆔") ("rest.whole" . "𝄻")
    ("rest.multiple" . "𝄺") ("rest.multiple.measure" . "𝄩")
    ("rest.half" . "𝄼") ("rest.quarter" . "𝄽") ("rest.eighth" . "𝄾")
    ("rest.sixteenth" . "𝄿") ("natural" . "♮") ("natural.t" . "𝄮")
    ("natural.b" . "𝄯") ("flat" . "♭") ("flat.t" . "𝄬") ("flat.b" . "𝄭")
    ("flat.double" . "𝄫") ("flat.quarter" . "𝄳") ("sharp" . "♯")
    ("sharp.t" . "𝄰") ("sharp.b" . "𝄱") ("sharp.double" . "𝄪")
    ("sharp.quarter" . "𝄲") ("bullet" . "•") ("circle.stroked" . "○")
    ("circle.stroked.tiny" . "∘") ("circle.stroked.small" . "⚬")
    ("circle.stroked.big" . "◯") ("circle.filled" . "●")
    ("circle.filled.tiny" . "⦁") ("circle.filled.small" . "∙")
    ("circle.filled.big" . "⬤") ("circle.dotted" . "◌")
    ("circle.nested" . "⊚") ("ellipse.stroked.h" . "⬭")
    ("ellipse.stroked.v" . "⬯") ("ellipse.filled.h" . "⬬")
    ("ellipse.filled.v" . "⬮") ("triangle.stroked.t" . "△")
    ("triangle.stroked.b" . "▽") ("triangle.stroked.r" . "▷")
    ("triangle.stroked.l" . "◁") ("triangle.stroked.bl" . "◺")
    ("triangle.stroked.br" . "◿") ("triangle.stroked.tl" . "◸")
    ("triangle.stroked.tr" . "◹") ("triangle.stroked.small.t" . "▵")
    ("triangle.stroked.small.b" . "▿") ("triangle.stroked.small.r" . "▹")
    ("triangle.stroked.small.l" . "◃") ("triangle.stroked.rounded" . "🛆")
    ("triangle.stroked.nested" . "⟁") ("triangle.stroked.dot" . "◬")
    ("triangle.filled.t" . "▲") ("triangle.filled.b" . "▼")
    ("triangle.filled.r" . "▶") ("triangle.filled.l" . "◀")
    ("triangle.filled.bl" . "◣") ("triangle.filled.br" . "◢")
    ("triangle.filled.tl" . "◤") ("triangle.filled.tr" . "◥")
    ("triangle.filled.small.t" . "▴") ("triangle.filled.small.b" . "▾")
    ("triangle.filled.small.r" . "▸") ("triangle.filled.small.l" . "◂")
    ("square.stroked" . "□") ("square.stroked.tiny" . "▫")
    ("square.stroked.small" . "◽") ("square.stroked.medium" . "◻")
    ("square.stroked.big" . "⬜") ("square.stroked.dotted" . "⬚")
    ("square.stroked.rounded" . "▢") ("square.filled" . "■")
    ("square.filled.tiny" . "▪") ("square.filled.small" . "◾")
    ("square.filled.medium" . "◼") ("square.filled.big" . "⬛")
    ("rect.stroked.h" . "▭") ("rect.stroked.v" . "▯")
    ("rect.filled.h" . "▬") ("rect.filled.v" . "▮")
    ("penta.stroked" . "⬠") ("penta.filled" . "⬟") ("hexa.stroked" . "⬡")
    ("hexa.filled" . "⬢") ("diamond.stroked" . "◇")
    ("diamond.stroked.small" . "⋄") ("diamond.stroked.medium" . "⬦")
    ("diamond.stroked.dot" . "⟐") ("diamond.filled" . "◆")
    ("diamond.filled.medium" . "⬥") ("diamond.filled.small" . "⬩")
    ("lozenge.stroked" . "◊") ("lozenge.stroked.small" . "⬫")
    ("lozenge.stroked.medium" . "⬨") ("lozenge.filled" . "⧫")
    ("lozenge.filled.small" . "⬪") ("lozenge.filled.medium" . "⬧")
    ("parallelogram.stroked" . "▱") ("parallelogram.filled" . "▰")
    ("star.op" . "⋆") ("star.stroked" . "☆") ("star.filled" . "★")
    ("arrow.r" . "→") ("arrow.r.long.bar" . "⟼") ("arrow.r.bar" . "↦")
    ("arrow.r.curve" . "⤷") ("arrow.r.turn" . "⮎")
    ("arrow.r.dashed" . "⇢") ("arrow.r.dotted" . "⤑")
    ("arrow.r.double" . "⇒") ("arrow.r.double.bar" . "⤇")
    ("arrow.r.double.long" . "⟹") ("arrow.r.double.long.bar" . "⟾")
    ("arrow.r.double.not" . "⇏") ("arrow.r.filled" . "➡")
    ("arrow.r.hook" . "↪") ("arrow.r.long" . "⟶")
    ("arrow.r.long.squiggly" . "⟿") ("arrow.r.loop" . "↬")
    ("arrow.r.not" . "↛") ("arrow.r.quad" . "⭆")
    ("arrow.r.squiggly" . "⇝") ("arrow.r.stop" . "⇥")
    ("arrow.r.stroked" . "⇨") ("arrow.r.tail" . "↣")
    ("arrow.r.tilde" . "⥲") ("arrow.r.triple" . "⇛")
    ("arrow.r.twohead.bar" . "⤅") ("arrow.r.twohead" . "↠")
    ("arrow.r.wave" . "↝") ("arrow.l" . "←") ("arrow.l.bar" . "↤")
    ("arrow.l.curve" . "⤶") ("arrow.l.turn" . "⮌")
    ("arrow.l.dashed" . "⇠") ("arrow.l.dotted" . "⬸")
    ("arrow.l.double" . "⇐") ("arrow.l.double.bar" . "⤆")
    ("arrow.l.double.long" . "⟸") ("arrow.l.double.long.bar" . "⟽")
    ("arrow.l.double.not" . "⇍") ("arrow.l.filled" . "⬅")
    ("arrow.l.hook" . "↩") ("arrow.l.long" . "⟵")
    ("arrow.l.long.bar" . "⟻") ("arrow.l.long.squiggly" . "⬳")
    ("arrow.l.loop" . "↫") ("arrow.l.not" . "↚") ("arrow.l.quad" . "⭅")
    ("arrow.l.squiggly" . "⇜") ("arrow.l.stop" . "⇤")
    ("arrow.l.stroked" . "⇦") ("arrow.l.tail" . "↢")
    ("arrow.l.tilde" . "⭉") ("arrow.l.triple" . "⇚")
    ("arrow.l.twohead.bar" . "⬶") ("arrow.l.twohead" . "↞")
    ("arrow.l.wave" . "↜") ("arrow.t" . "↑") ("arrow.t.bar" . "↥")
    ("arrow.t.curve" . "⤴") ("arrow.t.turn" . "⮍")
    ("arrow.t.dashed" . "⇡") ("arrow.t.double" . "⇑")
    ("arrow.t.filled" . "⬆") ("arrow.t.quad" . "⟰")
    ("arrow.t.stop" . "⤒") ("arrow.t.stroked" . "⇧")
    ("arrow.t.triple" . "⤊") ("arrow.t.twohead" . "↟") ("arrow.b" . "↓")
    ("arrow.b.bar" . "↧") ("arrow.b.curve" . "⤵") ("arrow.b.turn" . "⮏")
    ("arrow.b.dashed" . "⇣") ("arrow.b.double" . "⇓")
    ("arrow.b.filled" . "⬇") ("arrow.b.quad" . "⟱")
    ("arrow.b.stop" . "⤓") ("arrow.b.stroked" . "⇩")
    ("arrow.b.triple" . "⤋") ("arrow.b.twohead" . "↡")
    ("arrow.l.r" . "↔") ("arrow.l.r.double" . "⇔")
    ("arrow.l.r.double.long" . "⟺") ("arrow.l.r.double.not" . "⇎")
    ("arrow.l.r.filled" . "⬌") ("arrow.l.r.long" . "⟷")
    ("arrow.l.r.not" . "↮") ("arrow.l.r.stroked" . "⬄")
    ("arrow.l.r.wave" . "↭") ("arrow.t.b" . "↕")
    ("arrow.t.b.double" . "⇕") ("arrow.t.b.filled" . "⬍")
    ("arrow.t.b.stroked" . "⇳") ("arrow.tr" . "↗")
    ("arrow.tr.double" . "⇗") ("arrow.tr.filled" . "⬈")
    ("arrow.tr.hook" . "⤤") ("arrow.tr.stroked" . "⬀") ("arrow.br" . "↘")
    ("arrow.br.double" . "⇘") ("arrow.br.filled" . "⬊")
    ("arrow.br.hook" . "⤥") ("arrow.br.stroked" . "⬂") ("arrow.tl" . "↖")
    ("arrow.tl.double" . "⇖") ("arrow.tl.filled" . "⬉")
    ("arrow.tl.hook" . "⤣") ("arrow.tl.stroked" . "⬁") ("arrow.bl" . "↙")
    ("arrow.bl.double" . "⇙") ("arrow.bl.filled" . "⬋")
    ("arrow.bl.hook" . "⤦") ("arrow.bl.stroked" . "⬃")
    ("arrow.tl.br" . "⤡") ("arrow.tr.bl" . "⤢") ("arrow.ccw" . "↺")
    ("arrow.ccw.half" . "↶") ("arrow.cw" . "↻") ("arrow.cw.half" . "↷")
    ("arrow.zigzag" . "↯") ("arrows.rr" . "⇉") ("arrows.ll" . "⇇")
    ("arrows.tt" . "⇈") ("arrows.bb" . "⇊") ("arrows.lr" . "⇆")
    ("arrows.lr.stop" . "↹") ("arrows.rl" . "⇄") ("arrows.tb" . "⇅")
    ("arrows.bt" . "⇵") ("arrows.rrr" . "⇶") ("arrows.lll" . "⬱")
    ("arrowhead.t" . "⌃") ("arrowhead.b" . "⌄") ("harpoon.rt" . "⇀")
    ("harpoon.rt.bar" . "⥛") ("harpoon.rt.stop" . "⥓")
    ("harpoon.rb" . "⇁") ("harpoon.rb.bar" . "⥟")
    ("harpoon.rb.stop" . "⥗") ("harpoon.lt" . "↼")
    ("harpoon.lt.bar" . "⥚") ("harpoon.lt.stop" . "⥒")
    ("harpoon.lb" . "↽") ("harpoon.lb.bar" . "⥞")
    ("harpoon.lb.stop" . "⥖") ("harpoon.tl" . "↿")
    ("harpoon.tl.bar" . "⥠") ("harpoon.tl.stop" . "⥘")
    ("harpoon.tr" . "↾") ("harpoon.tr.bar" . "⥜")
    ("harpoon.tr.stop" . "⥔") ("harpoon.bl" . "⇃")
    ("harpoon.bl.bar" . "⥡") ("harpoon.bl.stop" . "⥙")
    ("harpoon.br" . "⇂") ("harpoon.br.bar" . "⥝")
    ("harpoon.br.stop" . "⥕") ("harpoon.lt.rt" . "⥎")
    ("harpoon.lb.rb" . "⥐") ("harpoon.lb.rt" . "⥋")
    ("harpoon.lt.rb" . "⥊") ("harpoon.tl.bl" . "⥑")
    ("harpoon.tr.br" . "⥏") ("harpoon.tl.br" . "⥍")
    ("harpoon.tr.bl" . "⥌") ("harpoons.rtrb" . "⥤")
    ("harpoons.blbr" . "⥥") ("harpoons.bltr" . "⥯")
    ("harpoons.lbrb" . "⥧") ("harpoons.ltlb" . "⥢")
    ("harpoons.ltrb" . "⇋") ("harpoons.ltrt" . "⥦")
    ("harpoons.rblb" . "⥩") ("harpoons.rtlb" . "⇌")
    ("harpoons.rtlt" . "⥨") ("harpoons.tlbr" . "⥮")
    ("harpoons.tltr" . "⥣") ("tack.r" . "⊢") ("tack.r.not" . "⊬")
    ("tack.r.long" . "⟝") ("tack.r.short" . "⊦") ("tack.r.double" . "⊨")
    ("tack.r.double.not" . "⊭") ("tack.l" . "⊣") ("tack.l.long" . "⟞")
    ("tack.l.short" . "⫞") ("tack.l.double" . "⫤") ("tack.t" . "⊥")
    ("tack.t.big" . "⟘") ("tack.t.double" . "⫫") ("tack.t.short" . "⫠")
    ("tack.b" . "⊤") ("tack.b.big" . "⟙") ("tack.b.double" . "⫪")
    ("tack.b.short" . "⫟") ("tack.l.r" . "⟛") ("alpha" . "α")
    ("beta" . "β") ("beta.alt" . "ϐ") ("chi" . "χ") ("delta" . "δ")
    ("epsilon" . "ε") ("epsilon.alt" . "ϵ") ("eta" . "η") ("gamma" . "γ")
    ("iota" . "ι") ("kai" . "ϗ") ("kappa" . "κ") ("kappa.alt" . "ϰ")
    ("lambda" . "λ") ("mu" . "μ") ("nu" . "ν") ("ohm" . "Ω")
    ("ohm.inv" . "℧") ("omega" . "ω") ("omicron" . "ο") ("phi" . "φ")
    ("phi.alt" . "ϕ") ("pi" . "π") ("pi.alt" . "ϖ") ("psi" . "ψ")
    ("rho" . "ρ") ("rho.alt" . "ϱ") ("sigma" . "σ") ("sigma.alt" . "ς")
    ("tau" . "τ") ("theta" . "θ") ("theta.alt" . "ϑ") ("upsilon" . "υ")
    ("xi" . "ξ") ("zeta" . "ζ") ("Alpha" . "Α") ("Beta" . "Β")
    ("Chi" . "Χ") ("Delta" . "Δ") ("Epsilon" . "Ε") ("Eta" . "Η")
    ("Gamma" . "Γ") ("Iota" . "Ι") ("Kai" . "Ϗ") ("Kappa" . "Κ")
    ("Lambda" . "Λ") ("Mu" . "Μ") ("Nu" . "Ν") ("Omega" . "Ω")
    ("Omicron" . "Ο") ("Phi" . "Φ") ("Pi" . "Π") ("Psi" . "Ψ")
    ("Rho" . "Ρ") ("Sigma" . "Σ") ("Tau" . "Τ") ("Theta" . "Θ")
    ("Upsilon" . "Υ") ("Xi" . "Ξ") ("Zeta" . "Ζ") ("aleph" . "א")
    ("alef" . "א") ("beth" . "ב") ("bet" . "ב") ("gimmel" . "ג")
    ("gimel" . "ג") ("daleth" . "ד") ("dalet" . "ד") ("shin" . "ש")
    ("AA" . "𝔸") ("BB" . "𝔹") ("CC" . "ℂ") ("DD" . "𝔻") ("EE" . "𝔼")
    ("FF" . "𝔽") ("GG" . "𝔾") ("HH" . "ℍ") ("II" . "𝕀") ("JJ" . "𝕁")
    ("KK" . "𝕂") ("LL" . "𝕃") ("MM" . "𝕄") ("NN" . "ℕ") ("OO" . "𝕆")
    ("PP" . "ℙ") ("QQ" . "ℚ") ("RR" . "ℝ") ("SS" . "𝕊") ("TT" . "𝕋")
    ("UU" . "𝕌") ("VV" . "𝕍") ("WW" . "𝕎") ("XX" . "𝕏") ("YY" . "𝕐")
    ("ZZ" . "ℤ") ("ell" . "ℓ") ("planck" . "ℎ") ("planck.reduce" . "ℏ")
    ("angstrom" . "Å") ("kelvin" . "K") ("Re" . "ℜ") ("Im" . "ℑ")
    ("dotless.i" . "𝚤") ("dotless.j" . "𝚥"))
  "An alist of names and their corresponding symbol.

https://typst.app/docs/reference/symbols/sym/"
  :group 'typst-ts-editing
  :type '(repeat
          (cons (string :tag "Name")
                (string :tag "Symbol"))))

(defcustom typst-ts-emoji-alist
  '(("abacus" . "🧮")
    ("abc" . "🔤")
    ("abcd" . "🔡")
    ("ABCD" . "🔠")
    ("accordion" . "🪗")
    ("aesculapius" . "⚕")
    ("airplane" . "✈")
    ("airplane.landing" . "🛬")
    ("airplane.small" . "🛩")
    ("airplane.takeoff" . "🛫")
    ("alembic" . "⚗")
    ("alien" . "👽")
    ("alien.monster" . "👾")
    ("ambulance" . "🚑")
    ("amphora" . "🏺")
    ("anchor" . "⚓")
    ("anger" . "💢")
    ("ant" . "🐜")
    ("apple.green" . "🍏")
    ("apple.red" . "🍎")
    ("arm.mech" . "🦾")
    ("arm.muscle" . "💪")
    ("arm.selfie" . "🤳")
    ("arrow.r.filled" . "➡")
    ("arrow.r.hook" . "↪")
    ("arrow.r.soon" . "🔜")
    ("arrow.l.filled" . "⬅")
    ("arrow.l.hook" . "↩")
    ("arrow.l.back" . "🔙")
    ("arrow.l.end" . "🔚")
    ("arrow.t.filled" . "⬆")
    ("arrow.t.curve" . "⤴")
    ("arrow.t.top" . "🔝")
    ("arrow.b.filled" . "⬇")
    ("arrow.b.curve" . "⤵")
    ("arrow.l.r" . "↔")
    ("arrow.l.r.on" . "🔛")
    ("arrow.t.b" . "↕")
    ("arrow.bl" . "↙")
    ("arrow.br" . "↘")
    ("arrow.tl" . "↖")
    ("arrow.tr" . "↗")
    ("arrows.cycle" . "🔄")
    ("ast" . "*")
    ("ast.box" . "✳")
    ("atm" . "🏧")
    ("atom" . "⚛")
    ("aubergine" . "🍆")
    ("avocado" . "🥑")
    ("axe" . "🪓")
    ("baby" . "👶")
    ("baby.angel" . "👼")
    ("baby.box" . "🚼")
    ("babybottle" . "🍼")
    ("backpack" . "🎒")
    ("bacon" . "🥓")
    ("badger" . "🦡")
    ("badminton" . "🏸")
    ("bagel" . "🥯")
    ("baggageclaim" . "🛄")
    ("baguette" . "🥖")
    ("balloon" . "🎈")
    ("ballot.check" . "☑")
    ("ballotbox" . "🗳")
    ("banana" . "🍌")
    ("banjo" . "🪕")
    ("bank" . "🏦")
    ("barberpole" . "💈")
    ("baseball" . "⚾")
    ("basecap" . "🧢")
    ("basket" . "🧺")
    ("basketball" . "⛹")
    ("basketball.ball" . "🏀")
    ("bat" . "🦇")
    ("bathtub" . "🛀")
    ("bathtub.foam" . "🛁")
    ("battery" . "🔋")
    ("battery.low" . "🪫")
    ("beach.palm" . "🏝")
    ("beach.umbrella" . "🏖")
    ("beads" . "📿")
    ("beans" . "🫘")
    ("bear" . "🐻")
    ("beaver" . "🦫")
    ("bed" . "🛏")
    ("bed.person" . "🛌")
    ("bee" . "🐝")
    ("beer" . "🍺")
    ("beer.clink" . "🍻")
    ("beet" . "🫜")
    ("beetle" . "🪲")
    ("beetle.lady" . "🐞")
    ("bell" . "🔔")
    ("bell.ding" . "🛎")
    ("bell.not" . "🔕")
    ("bento" . "🍱")
    ("bicyclist" . "🚴")
    ("bicyclist.mountain" . "🚵")
    ("bike" . "🚲")
    ("bike.not" . "🚳")
    ("bikini" . "👙")
    ("billiards" . "🎱")
    ("bin" . "🗑")
    ("biohazard" . "☣")
    ("bird" . "🐦")
    ("bison" . "🦬")
    ("blood" . "🩸")
    ("blouse" . "👚")
    ("blowfish" . "🐡")
    ("blueberries" . "🫐")
    ("boar" . "🐗")
    ("boat.sail" . "⛵")
    ("boat.row" . "🚣")
    ("boat.motor" . "🛥")
    ("boat.speed" . "🚤")
    ("boat.canoe" . "🛶")
    ("bolt" . "🔩")
    ("bomb" . "💣")
    ("bone" . "🦴")
    ("book.red" . "📕")
    ("book.blue" . "📘")
    ("book.green" . "📗")
    ("book.orange" . "📙")
    ("book.spiral" . "📒")
    ("book.open" . "📖")
    ("bookmark" . "🔖")
    ("books" . "📚")
    ("boomerang" . "🪃")
    ("bordercontrol" . "🛂")
    ("bouquet" . "💐")
    ("bow" . "🏹")
    ("bowl.spoon" . "🥣")
    ("bowl.steam" . "🍜")
    ("bowling" . "🎳")
    ("boxing" . "🥊")
    ("boy" . "👦")
    ("brain" . "🧠")
    ("bread" . "🍞")
    ("brick" . "🧱")
    ("bride" . "👰")
    ("bridge.fog" . "🌁")
    ("bridge.night" . "🌉")
    ("briefcase" . "💼")
    ("briefs" . "🩲")
    ("brightness.high" . "🔆")
    ("brightness.low" . "🔅")
    ("broccoli" . "🥦")
    ("broom" . "🧹")
    ("brush" . "🖌")
    ("bubble.speech.r" . "💬")
    ("bubble.speech.l" . "🗨")
    ("bubble.thought" . "💭")
    ("bubble.anger.r" . "🗯")
    ("bubbles" . "🫧")
    ("bubbletea" . "🧋")
    ("bucket" . "🪣")
    ("buffalo.water" . "🐃")
    ("bug" . "🐛")
    ("builder" . "👷")
    ("burger" . "🍔")
    ("burrito" . "🌯")
    ("bus" . "🚌")
    ("bus.front" . "🚍")
    ("bus.small" . "🚐")
    ("bus.stop" . "🚏")
    ("bus.trolley" . "🚎")
    ("butter" . "🧈")
    ("butterfly" . "🦋")
    ("button" . "🔲")
    ("button.alt" . "🔳")
    ("button.radio" . "🔘")
    ("cabinet.file" . "🗄")
    ("cablecar" . "🚠")
    ("cablecar.small" . "🚡")
    ("cactus" . "🌵")
    ("cake" . "🎂")
    ("cake.fish" . "🍥")
    ("cake.moon" . "🥮")
    ("cake.slice" . "🍰")
    ("calendar" . "📅")
    ("calendar.spiral" . "🗓")
    ("calendar.tearoff" . "📆")
    ("camel" . "🐫")
    ("camel.dromedar" . "🐪")
    ("camera" . "📷")
    ("camera.flash" . "📸")
    ("camera.movie" . "🎥")
    ("camera.movie.box" . "🎦")
    ("camera.video" . "📹")
    ("camping" . "🏕")
    ("can" . "🥫")
    ("candle" . "🕯")
    ("candy" . "🍬")
    ("cane" . "🦯")
    ("car" . "🚗")
    ("car.front" . "🚘")
    ("car.pickup" . "🛻")
    ("car.police" . "🚓")
    ("car.police.front" . "🚔")
    ("car.racing" . "🏎")
    ("car.rickshaw" . "🛺")
    ("car.suv" . "🚙")
    ("card.credit" . "💳")
    ("card.id" . "🪪")
    ("cardindex" . "📇")
    ("carrot" . "🥕")
    ("cart" . "🛒")
    ("cassette" . "📼")
    ("castle.eu" . "🏰")
    ("castle.jp" . "🏯")
    ("cat" . "🐈")
    ("cat.face" . "🐱")
    ("cat.face.angry" . "😾")
    ("cat.face.cry" . "😿")
    ("cat.face.heart" . "😻")
    ("cat.face.joy" . "😹")
    ("cat.face.kiss" . "😽")
    ("cat.face.laugh" . "😸")
    ("cat.face.shock" . "🙀")
    ("cat.face.smile" . "😺")
    ("cat.face.smirk" . "😼")
    ("chain" . "🔗")
    ("chains" . "⛓")
    ("chair" . "🪑")
    ("champagne" . "🍾")
    ("chart.bar" . "📊")
    ("chart.up" . "📈")
    ("chart.down" . "📉")
    ("chart.yen.up" . "💹")
    ("checkmark.heavy" . "✔")
    ("checkmark.box" . "✅")
    ("cheese" . "🧀")
    ("cherries" . "🍒")
    ("chess" . "♟")
    ("chestnut" . "🌰")
    ("chicken" . "🐔")
    ("chicken.baby" . "🐥")
    ("chicken.baby.egg" . "🐣")
    ("chicken.baby.head" . "🐤")
    ("chicken.leg" . "🍗")
    ("chicken.male" . "🐓")
    ("child" . "🧒")
    ("chipmunk" . "🐿")
    ("chocolate" . "🍫")
    ("chopsticks" . "🥢")
    ("church" . "⛪")
    ("church.love" . "💒")
    ("cigarette" . "🚬")
    ("cigarette.not" . "🚭")
    ("circle.black" . "⚫")
    ("circle.blue" . "🔵")
    ("circle.brown" . "🟤")
    ("circle.green" . "🟢")
    ("circle.orange" . "🟠")
    ("circle.purple" . "🟣")
    ("circle.white" . "⚪")
    ("circle.red" . "🔴")
    ("circle.yellow" . "🟡")
    ("circle.stroked" . "⭕")
    ("circus" . "🎪")
    ("city" . "🏙")
    ("city.dusk" . "🌆")
    ("city.night" . "🌃")
    ("city.sunset" . "🌇")
    ("clamp" . "🗜")
    ("clapperboard" . "🎬")
    ("climbing" . "🧗")
    ("clip" . "📎")
    ("clipboard" . "📋")
    ("clips" . "🖇")
    ("clock.one" . "🕐")
    ("clock.one.thirty" . "🕜")
    ("clock.two" . "🕑")
    ("clock.two.thirty" . "🕝")
    ("clock.three" . "🕒")
    ("clock.three.thirty" . "🕞")
    ("clock.four" . "🕓")
    ("clock.four.thirty" . "🕟")
    ("clock.five" . "🕔")
    ("clock.five.thirty" . "🕠")
    ("clock.six" . "🕕")
    ("clock.six.thirty" . "🕡")
    ("clock.seven" . "🕖")
    ("clock.seven.thirty" . "🕢")
    ("clock.eight" . "🕗")
    ("clock.eight.thirty" . "🕣")
    ("clock.nine" . "🕘")
    ("clock.nine.thirty" . "🕤")
    ("clock.ten" . "🕙")
    ("clock.ten.thirty" . "🕥")
    ("clock.eleven" . "🕚")
    ("clock.eleven.thirty" . "🕦")
    ("clock.twelve" . "🕛")
    ("clock.twelve.thirty" . "🕧")
    ("clock.alarm" . "⏰")
    ("clock.old" . "🕰")
    ("clock.timer" . "⏲")
    ("cloud" . "☁")
    ("cloud.dust" . "💨")
    ("cloud.rain" . "🌧")
    ("cloud.snow" . "🌨")
    ("cloud.storm" . "⛈")
    ("cloud.sun" . "⛅")
    ("cloud.sun.hidden" . "🌥")
    ("cloud.sun.rain" . "🌦")
    ("cloud.thunder" . "🌩")
    ("coat" . "🧥")
    ("coat.lab" . "🥼")
    ("cockroach" . "🪳")
    ("cocktail.martini" . "🍸")
    ("cocktail.tropical" . "🍹")
    ("coconut" . "🥥")
    ("coffee" . "☕")
    ("coffin" . "⚰")
    ("coin" . "🪙")
    ("comet" . "☄")
    ("compass" . "🧭")
    ("computer" . "🖥")
    ("computermouse" . "🖱")
    ("confetti" . "🎊")
    ("construction" . "🚧")
    ("controller" . "🎮")
    ("cookie" . "🍪")
    ("cookie.fortune" . "🥠")
    ("cooking" . "🍳")
    ("cool" . "🆒")
    ("copyright" . "©")
    ("coral" . "🪸")
    ("corn" . "🌽")
    ("couch" . "🛋")
    ("couple" . "💑")
    ("cow" . "🐄")
    ("cow.face" . "🐮")
    ("crab" . "🦀")
    ("crane" . "🏗")
    ("crayon" . "🖍")
    ("cricket" . "🦗")
    ("cricketbat" . "🏏")
    ("crocodile" . "🐊")
    ("croissant" . "🥐")
    ("crossmark" . "❌")
    ("crossmark.box" . "❎")
    ("crown" . "👑")
    ("crutch" . "🩼")
    ("crystal" . "🔮")
    ("cucumber" . "🥒")
    ("cup.straw" . "🥤")
    ("cupcake" . "🧁")
    ("curling" . "🥌")
    ("curry" . "🍛")
    ("custard" . "🍮")
    ("customs" . "🛃")
    ("cutlery" . "🍴")
    ("cyclone" . "🌀")
    ("dancing.man" . "🕺")
    ("dancing.woman" . "💃")
    ("dancing.women.bunny" . "👯")
    ("darts" . "🎯")
    ("dash.wave.double" . "〰")
    ("deer" . "🦌")
    ("desert" . "🏜")
    ("detective" . "🕵")
    ("diamond.blue" . "🔷")
    ("diamond.blue.small" . "🔹")
    ("diamond.orange" . "🔶")
    ("diamond.orange.small" . "🔸")
    ("diamond.dot" . "💠")
    ("die" . "🎲")
    ("dino.pod" . "🦕")
    ("dino.rex" . "🦖")
    ("disc.cd" . "💿")
    ("disc.dvd" . "📀")
    ("disc.mini" . "💽")
    ("discoball" . "🪩")
    ("diving" . "🤿")
    ("dodo" . "🦤")
    ("dog" . "🐕")
    ("dog.face" . "🐶")
    ("dog.guide" . "🦮")
    ("dog.poodle" . "🐩")
    ("dollar" . "💲")
    ("dolphin" . "🐬")
    ("donut" . "🍩")
    ("door" . "🚪")
    ("dove.peace" . "🕊")
    ("dragon" . "🐉")
    ("dragon.face" . "🐲")
    ("dress" . "👗")
    ("dress.kimono" . "👘")
    ("dress.sari" . "🥻")
    ("drop" . "💧")
    ("drops" . "💦")
    ("drum" . "🥁")
    ("drum.big" . "🪘")
    ("duck" . "🦆")
    ("dumpling" . "🥟")
    ("eagle" . "🦅")
    ("ear" . "👂")
    ("ear.aid" . "🦻")
    ("egg" . "🥚")
    ("eighteen.not" . "🔞")
    ("elephant" . "🐘")
    ("elevator" . "🛗")
    ("elf" . "🧝")
    ("email" . "📧")
    ("excl" . "❗")
    ("excl.white" . "❕")
    ("excl.double" . "‼")
    ("excl.quest" . "⁉")
    ("explosion" . "💥")
    ("extinguisher" . "🧯")
    ("eye" . "👁")
    ("eyes" . "👀")
    ("face.grin" . "😀")
    ("face.angry" . "😠")
    ("face.angry.red" . "😡")
    ("face.anguish" . "😧")
    ("face.astonish" . "😲")
    ("face.bandage" . "🤕")
    ("face.beam" . "😁")
    ("face.blank" . "😶")
    ("face.clown" . "🤡")
    ("face.cold" . "🥶")
    ("face.concern" . "😦")
    ("face.cool" . "😎")
    ("face.cover" . "🤭")
    ("face.cowboy" . "🤠")
    ("face.cry" . "😭")
    ("face.devil.smile" . "😈")
    ("face.devil.frown" . "👿")
    ("face.diagonal" . "🫤")
    ("face.disguise" . "🥸")
    ("face.distress" . "😫")
    ("face.dizzy" . "😵")
    ("face.dotted" . "🫥")
    ("face.down" . "😞")
    ("face.down.sweat" . "😓")
    ("face.drool" . "🤤")
    ("face.explode" . "🤯")
    ("face.eyeroll" . "🙄")
    ("face.friendly" . "☺")
    ("face.fear" . "😨")
    ("face.fear.sweat" . "😰")
    ("face.fever" . "🤒")
    ("face.flush" . "😳")
    ("face.frown" . "☹")
    ("face.frown.slight" . "🙁")
    ("face.frust" . "😣")
    ("face.goofy" . "🤪")
    ("face.halo" . "😇")
    ("face.happy" . "😊")
    ("face.heart" . "😍")
    ("face.hearts" . "🥰")
    ("face.heat" . "🥵")
    ("face.hug" . "🤗")
    ("face.inv" . "🙃")
    ("face.joy" . "😂")
    ("face.kiss" . "😗")
    ("face.kiss.smile" . "😙")
    ("face.kiss.heart" . "😘")
    ("face.kiss.blush" . "😚")
    ("face.lick" . "😋")
    ("face.lie" . "🤥")
    ("face.mask" . "😷")
    ("face.meh" . "😒")
    ("face.melt" . "🫠")
    ("face.money" . "🤑")
    ("face.monocle" . "🧐")
    ("face.nausea" . "🤢")
    ("face.nerd" . "🤓")
    ("face.neutral" . "😐")
    ("face.open" . "😃")
    ("face.party" . "🥳")
    ("face.peek" . "🫣")
    ("face.plead" . "🥺")
    ("face.relief" . "😌")
    ("face.rofl" . "🤣")
    ("face.sad" . "😔")
    ("face.salute" . "🫡")
    ("face.shock" . "😱")
    ("face.shush" . "🤫")
    ("face.skeptic" . "🤨")
    ("face.sleep" . "😴")
    ("face.sleepy" . "😪")
    ("face.smile" . "😄")
    ("face.smile.slight" . "🙂")
    ("face.smile.sweat" . "😅")
    ("face.smile.tear" . "🥲")
    ("face.smirk" . "😏")
    ("face.sneeze" . "🤧")
    ("face.speak.not" . "🫢")
    ("face.squint" . "😆")
    ("face.stars" . "🤩")
    ("face.straight" . "😑")
    ("face.suffer" . "😖")
    ("face.surprise" . "😯")
    ("face.symbols" . "🤬")
    ("face.tear" . "😢")
    ("face.tear.relief" . "😥")
    ("face.tear.withheld" . "🥹")
    ("face.teeth" . "😬")
    ("face.think" . "🤔")
    ("face.tired" . "🫩")
    ("face.tongue" . "😛")
    ("face.tongue.squint" . "😝")
    ("face.tongue.wink" . "😜")
    ("face.triumph" . "😤")
    ("face.unhappy" . "😕")
    ("face.vomit" . "🤮")
    ("face.weary" . "😩")
    ("face.wink" . "😉")
    ("face.woozy" . "🥴")
    ("face.worry" . "😟")
    ("face.wow" . "😮")
    ("face.yawn" . "🥱")
    ("face.zip" . "🤐")
    ("factory" . "🏭")
    ("fairy" . "🧚")
    ("faith.christ" . "✝")
    ("faith.dharma" . "☸")
    ("faith.islam" . "☪")
    ("faith.judaism" . "✡")
    ("faith.menorah" . "🕎")
    ("faith.om" . "🕉")
    ("faith.orthodox" . "☦")
    ("faith.peace" . "☮")
    ("faith.star.dot" . "🔯")
    ("faith.worship" . "🛐")
    ("faith.yinyang" . "☯")
    ("falafel" . "🧆")
    ("family" . "👪")
    ("fax" . "📠")
    ("feather" . "🪶")
    ("feeding.breast" . "🤱")
    ("fencing" . "🤺")
    ("ferriswheel" . "🎡")
    ("filebox" . "🗃")
    ("filedividers" . "🗂")
    ("film" . "🎞")
    ("finger.r" . "👉")
    ("finger.l" . "👈")
    ("finger.t" . "👆")
    ("finger.t.alt" . "☝")
    ("finger.b" . "👇")
    ("finger.front" . "🫵")
    ("finger.m" . "🖕")
    ("fingerprint" . "🫆")
    ("fingers.cross" . "🤞")
    ("fingers.pinch" . "🤌")
    ("fingers.snap" . "🫰")
    ("fire" . "🔥")
    ("firecracker" . "🧨")
    ("fireengine" . "🚒")
    ("fireworks" . "🎆")
    ("fish" . "🐟")
    ("fish.tropical" . "🐠")
    ("fishing" . "🎣")
    ("fist.front" . "👊")
    ("fist.r" . "🤜")
    ("fist.l" . "🤛")
    ("fist.raised" . "✊")
    ("flag.black" . "🏴")
    ("flag.white" . "🏳")
    ("flag.goal" . "🏁")
    ("flag.golf" . "⛳")
    ("flag.red" . "🚩")
    ("flags.jp.crossed" . "🎌")
    ("flamingo" . "🦩")
    ("flashlight" . "🔦")
    ("flatbread" . "🫓")
    ("fleur" . "⚜")
    ("floppy" . "💾")
    ("flower.hibiscus" . "🌺")
    ("flower.lotus" . "🪷")
    ("flower.pink" . "🌸")
    ("flower.rose" . "🌹")
    ("flower.sun" . "🌻")
    ("flower.tulip" . "🌷")
    ("flower.white" . "💮")
    ("flower.wilted" . "🥀")
    ("flower.yellow" . "🌼")
    ("fly" . "🪰")
    ("fog" . "🌫")
    ("folder" . "📁")
    ("folder.open" . "📂")
    ("fondue" . "🫕")
    ("foot" . "🦶")
    ("football" . "⚽")
    ("football.am" . "🏈")
    ("forex" . "💱")
    ("fountain" . "⛲")
    ("fox" . "🦊")
    ("free" . "🆓")
    ("fries" . "🍟")
    ("frisbee" . "🥏")
    ("frog.face" . "🐸")
    ("fuelpump" . "⛽")
    ("garlic" . "🧄")
    ("gear" . "⚙")
    ("gem" . "💎")
    ("genie" . "🧞")
    ("ghost" . "👻")
    ("giraffe" . "🦒")
    ("girl" . "👧")
    ("glass.clink" . "🥂")
    ("glass.milk" . "🥛")
    ("glass.pour" . "🫗")
    ("glass.tumbler" . "🥃")
    ("glasses" . "👓")
    ("glasses.sun" . "🕶")
    ("globe.am" . "🌎")
    ("globe.as.au" . "🌏")
    ("globe.eu.af" . "🌍")
    ("globe.meridian" . "🌐")
    ("gloves" . "🧤")
    ("goal" . "🥅")
    ("goat" . "🐐")
    ("goggles" . "🥽")
    ("golfing" . "🏌")
    ("gorilla" . "🦍")
    ("grapes" . "🍇")
    ("guard.man" . "💂")
    ("guitar" . "🎸")
    ("gymnastics" . "🤸")
    ("haircut" . "💇")
    ("hammer" . "🔨")
    ("hammer.pick" . "⚒")
    ("hammer.wrench" . "🛠")
    ("hamsa" . "🪬")
    ("hamster.face" . "🐹")
    ("hand.raised" . "✋")
    ("hand.raised.alt" . "🤚")
    ("hand.r" . "🫱")
    ("hand.l" . "🫲")
    ("hand.t" . "🫴")
    ("hand.b" . "🫳")
    ("hand.ok" . "👌")
    ("hand.call" . "🤙")
    ("hand.love" . "🤟")
    ("hand.part" . "🖖")
    ("hand.peace" . "✌")
    ("hand.pinch" . "🤏")
    ("hand.rock" . "🤘")
    ("hand.splay" . "🖐")
    ("hand.wave" . "👋")
    ("hand.write" . "✍")
    ("handbag" . "👜")
    ("handball" . "🤾")
    ("handholding.man.man" . "👬")
    ("handholding.woman.man" . "👫")
    ("handholding.woman.woman" . "👭")
    ("hands.folded" . "🙏")
    ("hands.palms" . "🤲")
    ("hands.clap" . "👏")
    ("hands.heart" . "🫶")
    ("hands.open" . "👐")
    ("hands.raised" . "🙌")
    ("hands.shake" . "🤝")
    ("harp" . "🪉")
    ("hash" . "#")
    ("hat.ribbon" . "👒")
    ("hat.top" . "🎩")
    ("headphone" . "🎧")
    ("heart" . "❤")
    ("heart.arrow" . "💘")
    ("heart.beat" . "💓")
    ("heart.black" . "🖤")
    ("heart.blue" . "💙")
    ("heart.box" . "💟")
    ("heart.broken" . "💔")
    ("heart.brown" . "🤎")
    ("heart.double" . "💕")
    ("heart.excl" . "❣")
    ("heart.green" . "💚")
    ("heart.grow" . "💗")
    ("heart.orange" . "🧡")
    ("heart.purple" . "💜")
    ("heart.real" . "🫀")
    ("heart.revolve" . "💞")
    ("heart.ribbon" . "💝")
    ("heart.spark" . "💖")
    ("heart.white" . "🤍")
    ("heart.yellow" . "💛")
    ("hedgehog" . "🦔")
    ("helicopter" . "🚁")
    ("helix" . "🧬")
    ("helmet.cross" . "⛑")
    ("helmet.military" . "🪖")
    ("hippo" . "🦛")
    ("hockey" . "🏑")
    ("hole" . "🕳")
    ("honey" . "🍯")
    ("hongbao" . "🧧")
    ("hook" . "🪝")
    ("horn.postal" . "📯")
    ("horse" . "🐎")
    ("horse.carousel" . "🎠")
    ("horse.face" . "🐴")
    ("horse.race" . "🏇")
    ("hospital" . "🏥")
    ("hotdog" . "🌭")
    ("hotel" . "🏨")
    ("hotel.love" . "🏩")
    ("hotspring" . "♨")
    ("hourglass" . "⌛")
    ("hourglass.flow" . "⏳")
    ("house" . "🏠")
    ("house.derelict" . "🏚")
    ("house.garden" . "🏡")
    ("house.multiple" . "🏘")
    ("hundred" . "💯")
    ("hut" . "🛖")
    ("ice" . "🧊")
    ("icecream" . "🍨")
    ("icecream.shaved" . "🍧")
    ("icecream.soft" . "🍦")
    ("icehockey" . "🏒")
    ("id" . "🆔")
    ("info" . "ℹ")
    ("izakaya" . "🏮")
    ("jar" . "🫙")
    ("jeans" . "👖")
    ("jigsaw" . "🧩")
    ("joystick" . "🕹")
    ("juggling" . "🤹")
    ("juice" . "🧃")
    ("kaaba" . "🕋")
    ("kadomatsu" . "🎍")
    ("kangaroo" . "🦘")
    ("gachi" . "🈷")
    ("go" . "🈴")
    ("hi" . "㊙")
    ("ka" . "🉑")
    ("kachi" . "🈹")
    ("kara" . "🈳")
    ("kon" . "🈲")
    ("man" . "👨")
    ("man.box" . "🚹")
    ("man.crown" . "🤴")
    ("man.guapimao" . "👲")
    ("man.levitate" . "🕴")
    ("man.old" . "👴")
    ("man.pregnant" . "🫃")
    ("man.turban" . "👳")
    ("man.tuxedo" . "🤵")
    ("muryo" . "🈚")
    ("shin" . "🈸")
    ("shuku" . "㊗")
    ("toku" . "🉐")
    ("yo" . "🈺")
    ("yubi" . "🈯")
    ("yuryo" . "🈶")
    ("koko" . "🈁")
    ("sa" . "🈂")
    ("kebab" . "🥙")
    ("key" . "🔑")
    ("key.old" . "🗝")
    ("keyboard" . "⌨")
    ("kiss" . "💏")
    ("kissmark" . "💋")
    ("kite" . "🪁")
    ("kiwi" . "🥝")
    ("knife" . "🔪")
    ("knife.dagger" . "🗡")
    ("knot" . "🪢")
    ("koala" . "🐨")
    ("koinobori" . "🎏")
    ("label" . "🏷")
    ("lacrosse" . "🥍")
    ("ladder" . "🪜")
    ("lamp.diya" . "🪔")
    ("laptop" . "💻")
    ("a" . "🅰")
    ("ab" . "🆎")
    ("b" . "🅱")
    ("cl" . "🆑")
    ("o" . "🅾")
    ("leaf.clover.three" . "☘")
    ("leaf.clover.four" . "🍀")
    ("leaf.fall" . "🍂")
    ("leaf.herb" . "🌿")
    ("leaf.maple" . "🍁")
    ("leaf.wind" . "🍃")
    ("leftluggage" . "🛅")
    ("leg" . "🦵")
    ("leg.mech" . "🦿")
    ("lemon" . "🍋")
    ("leopard" . "🐆")
    ("letter.love" . "💌")
    ("liberty" . "🗽")
    ("lightbulb" . "💡")
    ("lightning" . "⚡")
    ("lion" . "🦁")
    ("lipstick" . "💄")
    ("litter" . "🚮")
    ("litter.not" . "🚯")
    ("lizard" . "🦎")
    ("llama" . "🦙")
    ("lobster" . "🦞")
    ("lock" . "🔒")
    ("lock.key" . "🔐")
    ("lock.open" . "🔓")
    ("lock.pen" . "🔏")
    ("lollipop" . "🍭")
    ("lotion" . "🧴")
    ("luggage" . "🧳")
    ("lungs" . "🫁")
    ("mage" . "🧙")
    ("magnet" . "🧲")
    ("magnify.r" . "🔎")
    ("magnify.l" . "🔍")
    ("mahjong.dragon.red" . "🀄")
    ("mail" . "✉")
    ("mail.arrow" . "📩")
    ("mailbox.closed.empty" . "📪")
    ("mailbox.closed.full" . "📫")
    ("mailbox.open.empty" . "📭")
    ("mailbox.open.full" . "📬")
    ("mammoth" . "🦣")
    ("mango" . "🥭")
    ("map.world" . "🗺")
    ("map.jp" . "🗾")
    ("martialarts" . "🥋")
    ("masks" . "🎭")
    ("mate" . "🧉")
    ("matryoshka" . "🪆")
    ("meat" . "🥩")
    ("meat.bone" . "🍖")
    ("medal.first" . "🥇")
    ("medal.second" . "🥈")
    ("medal.third" . "🥉")
    ("medal.sports" . "🏅")
    ("medal.military" . "🎖")
    ("megaphone" . "📢")
    ("megaphone.simple" . "📣")
    ("melon" . "🍈")
    ("merperson" . "🧜")
    ("metro" . "Ⓜ")
    ("microbe" . "🦠")
    ("microphone" . "🎤")
    ("microphone.studio" . "🎙")
    ("microscope" . "🔬")
    ("milkyway" . "🌌")
    ("mirror" . "🪞")
    ("mixer" . "🎛")
    ("money.bag" . "💰")
    ("money.dollar" . "💵")
    ("money.euro" . "💶")
    ("money.pound" . "💷")
    ("money.yen" . "💴")
    ("money.wings" . "💸")
    ("monkey" . "🐒")
    ("monkey.face" . "🐵")
    ("monkey.hear.not" . "🙉")
    ("monkey.see.not" . "🙈")
    ("monkey.speak.not" . "🙊")
    ("moon.crescent" . "🌙")
    ("moon.full" . "🌕")
    ("moon.full.face" . "🌝")
    ("moon.new" . "🌑")
    ("moon.new.face" . "🌚")
    ("moon.wane.one" . "🌖")
    ("moon.wane.two" . "🌗")
    ("moon.wane.three.face" . "🌜")
    ("moon.wane.three" . "🌘")
    ("moon.wax.one" . "🌒")
    ("moon.wax.two" . "🌓")
    ("moon.wax.two.face" . "🌛")
    ("moon.wax.three" . "🌔")
    ("mortarboard" . "🎓")
    ("mosque" . "🕌")
    ("mosquito" . "🦟")
    ("motorcycle" . "🏍")
    ("motorway" . "🛣")
    ("mountain" . "⛰")
    ("mountain.fuji" . "🗻")
    ("mountain.snow" . "🏔")
    ("mountain.sunrise" . "🌄")
    ("mouse" . "🐁")
    ("mouse.face" . "🐭")
    ("mousetrap" . "🪤")
    ("mouth" . "👄")
    ("mouth.bite" . "🫦")
    ("moyai" . "🗿")
    ("museum" . "🏛")
    ("mushroom" . "🍄")
    ("musicalscore" . "🎼")
    ("nails.polish" . "💅")
    ("namebadge" . "📛")
    ("nazar" . "🧿")
    ("necktie" . "👔")
    ("needle" . "🪡")
    ("nest.empty" . "🪹")
    ("nest.eggs" . "🪺")
    ("new" . "🆕")
    ("newspaper" . "📰")
    ("newspaper.rolled" . "🗞")
    ("ng" . "🆖")
    ("ningyo" . "🎎")
    ("ninja" . "🥷")
    ("noentry" . "⛔")
    ("nose" . "👃")
    ("notebook" . "📓")
    ("notebook.deco" . "📔")
    ("notepad" . "🗒")
    ("notes" . "🎵")
    ("notes.triple" . "🎶")
    ("numbers" . "🔢")
    ("octopus" . "🐙")
    ("office" . "🏢")
    ("oil" . "🛢")
    ("ok" . "🆗")
    ("olive" . "🫒")
    ("oni" . "👹")
    ("onion" . "🧅")
    ("orangutan" . "🦧")
    ("otter" . "🦦")
    ("owl" . "🦉")
    ("ox" . "🐂")
    ("oyster" . "🦪")
    ("package" . "📦")
    ("paella" . "🥘")
    ("page" . "📄")
    ("page.curl" . "📃")
    ("page.pencil" . "📝")
    ("pager" . "📟")
    ("pages.tabs" . "📑")
    ("painting" . "🖼")
    ("palette" . "🎨")
    ("pancakes" . "🥞")
    ("panda" . "🐼")
    ("parachute" . "🪂")
    ("park" . "🏞")
    ("parking" . "🅿")
    ("parrot" . "🦜")
    ("partalteration" . "〽")
    ("party" . "🎉")
    ("peach" . "🍑")
    ("peacock" . "🦚")
    ("peanuts" . "🥜")
    ("pear" . "🍐")
    ("pedestrian" . "🚶")
    ("pedestrian.not" . "🚷")
    ("pen.ball" . "🖊")
    ("pen.fountain" . "🖋")
    ("pencil" . "✏")
    ("penguin" . "🐧")
    ("pepper" . "🫑")
    ("pepper.hot" . "🌶")
    ("person" . "🧑")
    ("person.angry" . "🙎")
    ("person.beard" . "🧔")
    ("person.blonde" . "👱")
    ("person.bow" . "🙇")
    ("person.crown" . "🫅")
    ("person.deaf" . "🧏")
    ("person.facepalm" . "🤦")
    ("person.frown" . "🙍")
    ("person.hijab" . "🧕")
    ("person.kneel" . "🧎")
    ("person.lotus" . "🧘")
    ("person.massage" . "💆")
    ("person.no" . "🙅")
    ("person.ok" . "🙆")
    ("person.old" . "🧓")
    ("person.pregnant" . "🫄")
    ("person.raise" . "🙋")
    ("person.sassy" . "💁")
    ("person.shrug" . "🤷")
    ("person.stand" . "🧍")
    ("person.steam" . "🧖")
    ("petri" . "🧫")
    ("phone" . "📱")
    ("phone.arrow" . "📲")
    ("phone.classic" . "☎")
    ("phone.not" . "📵")
    ("phone.off" . "📴")
    ("phone.receiver" . "📞")
    ("phone.signal" . "📶")
    ("phone.vibrate" . "📳")
    ("piano" . "🎹")
    ("pick" . "⛏")
    ("pie" . "🥧")
    ("pig" . "🐖")
    ("pig.face" . "🐷")
    ("pig.nose" . "🐽")
    ("pill" . "💊")
    ("pin" . "📌")
    ("pin.round" . "📍")
    ("pinata" . "🪅")
    ("pineapple" . "🍍")
    ("pingpong" . "🏓")
    ("pistol" . "🔫")
    ("pizza" . "🍕")
    ("placard" . "🪧")
    ("planet" . "🪐")
    ("plant" . "🪴")
    ("plaster" . "🩹")
    ("plate.cutlery" . "🍽")
    ("playback.down" . "⏬")
    ("playback.eject" . "⏏")
    ("playback.forward" . "⏩")
    ("playback.pause" . "⏸")
    ("playback.record" . "⏺")
    ("playback.repeat" . "🔁")
    ("playback.repeat.once" . "🔂")
    ("playback.repeat.v" . "🔃")
    ("playback.restart" . "⏮")
    ("playback.rewind" . "⏪")
    ("playback.shuffle" . "🔀")
    ("playback.skip" . "⏭")
    ("playback.stop" . "⏹")
    ("playback.toggle" . "⏯")
    ("playback.up" . "⏫")
    ("playingcard.flower" . "🎴")
    ("playingcard.joker" . "🃏")
    ("plunger" . "🪠")
    ("policeofficer" . "👮")
    ("poo" . "💩")
    ("popcorn" . "🍿")
    ("post.eu" . "🏤")
    ("post.jp" . "🏣")
    ("postbox" . "📮")
    ("potato" . "🥔")
    ("potato.sweet" . "🍠")
    ("pouch" . "👝")
    ("powerplug" . "🔌")
    ("present" . "🎁")
    ("pretzel" . "🥨")
    ("printer" . "🖨")
    ("prints.foot" . "👣")
    ("prints.paw" . "🐾")
    ("prohibited" . "🚫")
    ("projector" . "📽")
    ("pumpkin.lantern" . "🎃")
    ("purse" . "👛")
    ("quest" . "❓")
    ("quest.white" . "❔")
    ("rabbit" . "🐇")
    ("rabbit.face" . "🐰")
    ("raccoon" . "🦝")
    ("radio" . "📻")
    ("radioactive" . "☢")
    ("railway" . "🛤")
    ("rainbow" . "🌈")
    ("ram" . "🐏")
    ("rat" . "🐀")
    ("razor" . "🪒")
    ("receipt" . "🧾")
    ("recycling" . "♻")
    ("reg" . "®")
    ("restroom" . "🚻")
    ("rhino" . "🦏")
    ("ribbon" . "🎀")
    ("ribbon.remind" . "🎗")
    ("rice" . "🍚")
    ("rice.cracker" . "🍘")
    ("rice.ear" . "🌾")
    ("rice.onigiri" . "🍙")
    ("ring" . "💍")
    ("ringbuoy" . "🛟")
    ("robot" . "🤖")
    ("rock" . "🪨")
    ("rocket" . "🚀")
    ("rollercoaster" . "🎢")
    ("rosette" . "🏵")
    ("rugby" . "🏉")
    ("ruler" . "📏")
    ("ruler.triangle" . "📐")
    ("running" . "🏃")
    ("safetypin" . "🧷")
    ("safetyvest" . "🦺")
    ("sake" . "🍶")
    ("salad" . "🥗")
    ("salt" . "🧂")
    ("sandwich" . "🥪")
    ("santa.man" . "🎅")
    ("santa.woman" . "🤶")
    ("satdish" . "📡")
    ("satellite" . "🛰")
    ("saw" . "🪚")
    ("saxophone" . "🎷")
    ("scales" . "⚖")
    ("scarf" . "🧣")
    ("school" . "🏫")
    ("scissors" . "✂")
    ("scooter" . "🛴")
    ("scooter.motor" . "🛵")
    ("scorpion" . "🦂")
    ("screwdriver" . "🪛")
    ("scroll" . "📜")
    ("seal" . "🦭")
    ("seat" . "💺")
    ("seedling" . "🌱")
    ("shark" . "🦈")
    ("sheep" . "🐑")
    ("shell.spiral" . "🐚")
    ("shield" . "🛡")
    ("ship" . "🚢")
    ("ship.cruise" . "🛳")
    ("ship.ferry" . "⛴")
    ("shirt.sports" . "🎽")
    ("shirt.t" . "👕")
    ("shoe" . "👞")
    ("shoe.ballet" . "🩰")
    ("shoe.flat" . "🥿")
    ("shoe.heel" . "👠")
    ("shoe.hike" . "🥾")
    ("shoe.ice" . "⛸")
    ("shoe.roller" . "🛼")
    ("shoe.sandal.heel" . "👡")
    ("shoe.ski" . "🎿")
    ("shoe.sneaker" . "👟")
    ("shoe.tall" . "👢")
    ("shoe.thong" . "🩴")
    ("shopping" . "🛍")
    ("shorts" . "🩳")
    ("shoshinsha" . "🔰")
    ("shovel" . "🪏")
    ("shower" . "🚿")
    ("shrimp" . "🦐")
    ("shrimp.fried" . "🍤")
    ("shrine" . "⛩")
    ("sign.crossing" . "🚸")
    ("sign.stop" . "🛑")
    ("silhouette" . "👤")
    ("silhouette.double" . "👥")
    ("silhouette.hug" . "🫂")
    ("silhouette.speak" . "🗣")
    ("siren" . "🚨")
    ("skateboard" . "🛹")
    ("skewer.dango" . "🍡")
    ("skewer.oden" . "🍢")
    ("skiing" . "⛷")
    ("skull" . "💀")
    ("skull.bones" . "☠")
    ("skunk" . "🦨")
    ("sled" . "🛷")
    ("slide" . "🛝")
    ("slider" . "🎚")
    ("sloth" . "🦥")
    ("slots" . "🎰")
    ("snail" . "🐌")
    ("snake" . "🐍")
    ("snowboarding" . "🏂")
    ("snowflake" . "❄")
    ("snowman" . "⛄")
    ("snowman.snow" . "☃")
    ("soap" . "🧼")
    ("socks" . "🧦")
    ("softball" . "🥎")
    ("sos" . "🆘")
    ("soup" . "🍲")
    ("spaghetti" . "🍝")
    ("sparkle.box" . "❇")
    ("sparkler" . "🎇")
    ("sparkles" . "✨")
    ("speaker" . "🔈")
    ("speaker.not" . "🔇")
    ("speaker.wave" . "🔉")
    ("speaker.waves" . "🔊")
    ("spider" . "🕷")
    ("spiderweb" . "🕸")
    ("spinach" . "🥬")
    ("splatter" . "🫟")
    ("sponge" . "🧽")
    ("spoon" . "🥄")
    ("square.black" . "⬛")
    ("square.black.tiny" . "▪")
    ("square.black.small" . "◾")
    ("square.black.medium" . "◼")
    ("square.white" . "⬜")
    ("square.white.tiny" . "▫")
    ("square.white.small" . "◽")
    ("square.white.medium" . "◻")
    ("square.blue" . "🟦")
    ("square.brown" . "🟫")
    ("square.green" . "🟩")
    ("square.orange" . "🟧")
    ("square.purple" . "🟪")
    ("square.red" . "🟥")
    ("square.yellow" . "🟨")
    ("squid" . "🦑")
    ("stadium" . "🏟")
    ("star" . "⭐")
    ("star.arc" . "💫")
    ("star.box" . "✴")
    ("star.glow" . "🌟")
    ("star.shoot" . "🌠")
    ("stethoscope" . "🩺")
    ("store.big" . "🏬")
    ("store.small" . "🏪")
    ("strawberry" . "🍓")
    ("suit.club" . "♣")
    ("suit.diamond" . "♦")
    ("suit.heart" . "♥")
    ("suit.spade" . "♠")
    ("sun" . "☀")
    ("sun.cloud" . "🌤")
    ("sun.face" . "🌞")
    ("sunrise" . "🌅")
    ("superhero" . "🦸")
    ("supervillain" . "🦹")
    ("surfing" . "🏄")
    ("sushi" . "🍣")
    ("swan" . "🦢")
    ("swimming" . "🏊")
    ("swimsuit" . "🩱")
    ("swords" . "⚔")
    ("symbols" . "🔣")
    ("synagogue" . "🕍")
    ("syringe" . "💉")
    ("taco" . "🌮")
    ("takeout" . "🥡")
    ("tamale" . "🫔")
    ("tanabata" . "🎋")
    ("tangerine" . "🍊")
    ("tap" . "🚰")
    ("tap.not" . "🚱")
    ("taxi" . "🚕")
    ("taxi.front" . "🚖")
    ("teacup" . "🍵")
    ("teapot" . "🫖")
    ("teddy" . "🧸")
    ("telescope" . "🔭")
    ("temple" . "🛕")
    ("ten" . "🔟")
    ("tengu" . "👺")
    ("tennis" . "🎾")
    ("tent" . "⛺")
    ("testtube" . "🧪")
    ("thermometer" . "🌡")
    ("thread" . "🧵")
    ("thumb.up" . "👍")
    ("thumb.down" . "👎")
    ("ticket.event" . "🎟")
    ("ticket.travel" . "🎫")
    ("tiger" . "🐅")
    ("tiger.face" . "🐯")
    ("tm" . "™")
    ("toilet" . "🚽")
    ("toiletpaper" . "🧻")
    ("tomato" . "🍅")
    ("tombstone" . "🪦")
    ("tongue" . "👅")
    ("toolbox" . "🧰")
    ("tooth" . "🦷")
    ("toothbrush" . "🪥")
    ("tornado" . "🌪")
    ("tower.tokyo" . "🗼")
    ("trackball" . "🖲")
    ("tractor" . "🚜")
    ("trafficlight.v" . "🚦")
    ("trafficlight.h" . "🚥")
    ("train" . "🚆")
    ("train.car" . "🚃")
    ("train.light" . "🚈")
    ("train.metro" . "🚇")
    ("train.mono" . "🚝")
    ("train.mountain" . "🚞")
    ("train.speed" . "🚄")
    ("train.speed.bullet" . "🚅")
    ("train.steam" . "🚂")
    ("train.stop" . "🚉")
    ("train.suspend" . "🚟")
    ("train.tram" . "🚊")
    ("train.tram.car" . "🚋")
    ("transgender" . "⚧")
    ("tray.inbox" . "📥")
    ("tray.mail" . "📨")
    ("tray.outbox" . "📤")
    ("tree.deciduous" . "🌳")
    ("tree.evergreen" . "🌲")
    ("tree.leafless" . "🪾")
    ("tree.palm" . "🌴")
    ("tree.xmas" . "🎄")
    ("triangle.r" . "▶")
    ("triangle.l" . "◀")
    ("triangle.t" . "🔼")
    ("triangle.b" . "🔽")
    ("triangle.t.red" . "🔺")
    ("triangle.b.red" . "🔻")
    ("trident" . "🔱")
    ("troll" . "🧌")
    ("trophy" . "🏆")
    ("truck" . "🚚")
    ("truck.trailer" . "🚛")
    ("trumpet" . "🎺")
    ("tsukimi" . "🎑")
    ("turkey" . "🦃")
    ("turtle" . "🐢")
    ("tv" . "📺")
    ("ufo" . "🛸")
    ("umbrella.open" . "☂")
    ("umbrella.closed" . "🌂")
    ("umbrella.rain" . "☔")
    ("umbrella.sun" . "⛱")
    ("unicorn" . "🦄")
    ("unknown" . "🦳")
    ("up" . "🆙")
    ("urn" . "⚱")
    ("vampire" . "🧛")
    ("violin" . "🎻")
    ("volcano" . "🌋")
    ("volleyball" . "🏐")
    ("vs" . "🆚")
    ("waffle" . "🧇")
    ("wand" . "🪄")
    ("warning" . "⚠")
    ("watch" . "⌚")
    ("watch.stop" . "⏱")
    ("watermelon" . "🍉")
    ("waterpolo" . "🤽")
    ("wave" . "🌊")
    ("wc" . "🚾")
    ("weightlifting" . "🏋")
    ("whale" . "🐋")
    ("whale.spout" . "🐳")
    ("wheel" . "🛞")
    ("wheelchair" . "🦽")
    ("wheelchair.box" . "♿")
    ("wheelchair.motor" . "🦼")
    ("wind" . "🌬")
    ("windchime" . "🎐")
    ("window" . "🪟")
    ("wine" . "🍷")
    ("wolf" . "🐺")
    ("woman" . "👩")
    ("woman.box" . "🚺")
    ("woman.crown" . "👸")
    ("woman.old" . "👵")
    ("woman.pregnant" . "🤰")
    ("wood" . "🪵")
    ("worm" . "🪱")
    ("wrench" . "🔧")
    ("wrestling" . "🤼")
    ("xray" . "🩻")
    ("yarn" . "🧶")
    ("yoyo" . "🪀")
    ("zebra" . "🦓")
    ("zodiac.aquarius" . "♒")
    ("zodiac.aries" . "♈")
    ("zodiac.cancer" . "♋")
    ("zodiac.capri" . "♑")
    ("zodiac.gemini" . "♊")
    ("zodiac.leo" . "♌")
    ("zodiac.libra" . "♎")
    ("zodiac.ophi" . "⛎")
    ("zodiac.pisces" . "♓")
    ("zodiac.sagit" . "♐")
    ("zodiac.scorpio" . "♏")
    ("zodiac.taurus" . "♉")
    ("zodiac.virgo" . "♍")
    ("zombie" . "🧟")
    ("zzz" . "💤"))
  "An alist of name and corresponding emoji.

Emojis: https://typst.app/docs/reference/symbols/emoji/"
  :group 'typst-ts-editing
  :type '(repeat
          (cons (string :tag "Name")
                (string :tag "Emoji"))))

(provide 'typst-ts-symbols)

;;; typst-ts-symbols.el ends here
