;;; fj-test.el --- Tests for fj.el  -*- lexical-binding: nil -*-

;;; Commentary

;; Tests for fj.el
;; We use exemplify-ert/-eval to make expect style tests.
;; See <https://flandrew.srht.site/listful/sw-emacs-exemplify-ert.html>.

;; To get the data for variables, the commented function call under their
;; name is evaluated by `pp-eval-last-sexp' with a prefix argument, which inserts
;; it into the buffer.

;; To create the expect tests, do something like

;; (exemplify-ert fj-test-comment-cands
;;   (fj-get-comment-candidates fj-test-comments)

;; and with point after the expression, call `exemplify-eval-do', which
;; will insert the return value of the expression, following a =>, into the
;; buffer. If you have a set of expressions in a test, mark them and call
;; `exemplify-eval-do' with a prefix arg of 3 (i.e. call M-3
;; `exemplify-eval-do'). This will insert the return values of all
;; expressions after each one.

;; TODO: test the arity of buffer-spec viewfun matches length of viewargs
;; for all views.

(require 'exemplify-ert)
(require 'exemplify-eval)
(require 'fj)

(defvar fj-test-repos
  ;; (fj-get-repos "5" nil :silent nil "recentupdate")
  '(((id . 142698)
     (owner
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (name . "fj.el")
     (full_name . "martianh/fj.el")
     (description . "An Emacs client for Forgejo instances (such as Codeberg).")
     (empty . :json-false)
     (private . :json-false)
     (fork . :json-false)
     (template . :json-false)
     (parent)
     (mirror . :json-false)
     (size . 12242)
     (language . "Emacs Lisp")
     (languages_url . "https://codeberg.org/api/v1/repos/martianh/fj.el/languages")
     (html_url . "https://codeberg.org/martianh/fj.el")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el")
     (link . "")
     (ssh_url . "ssh://git@codeberg.org/martianh/fj.el.git")
     (clone_url . "https://codeberg.org/martianh/fj.el.git")
     (original_url . "")
     (website . "")
     (stars_count . 34)
     (forks_count . 5)
     (watchers_count . 4)
     (open_issues_count . 41)
     (open_pr_counter . 0)
     (release_counter . 0)
     (default_branch . "main")
     (archived . :json-false)
     (created_at . "2023-09-11T17:17:45+02:00")
     (updated_at . "2025-08-16T13:42:58+02:00")
     (archived_at . "1970-01-01T01:00:00+01:00")
     (permissions
      (admin . t)
      (push . t)
      (pull . t))
     (has_issues . t)
     (internal_tracker
      (enable_time_tracker . t)
      (allow_only_contributors_to_track_time . :json-false)
      (enable_issue_dependencies . :json-false))
     (has_wiki . :json-false)
     (wiki_branch . "master")
     (globally_editable_wiki . :json-false)
     (has_pull_requests . t)
     (has_projects . t)
     (has_releases . t)
     (has_packages . t)
     (has_actions . t)
     (ignore_whitespace_conflicts . :json-false)
     (allow_merge_commits . t)
     (allow_rebase . t)
     (allow_rebase_explicit . t)
     (allow_squash_merge . t)
     (allow_fast_forward_only_merge . t)
     (allow_rebase_update . t)
     (default_delete_branch_after_merge . :json-false)
     (default_merge_style . "rebase")
     (default_allow_maintainer_edit . :json-false)
     (default_update_style . "merge")
     (avatar_url . "")
     (internal . :json-false)
     (mirror_interval . "")
     (object_format_name . "sha1")
     (mirror_updated . "0001-01-01T00:00:00Z")
     (repo_transfer)
     (topics "codeberg" "emacs" "emacs-lisp" "forge" "forgejo" "git" "magit" "version-control"))
    ((id . 101093)
     (owner
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (name . "etym.el")
     (full_name . "martianh/etym.el")
     (description . "Basic interface to https://etymonline.com in Emacs.")
     (empty . :json-false)
     (private . :json-false)
     (fork . :json-false)
     (template . :json-false)
     (parent)
     (mirror . :json-false)
     (size . 31)
     (language . "Emacs Lisp")
     (languages_url . "https://codeberg.org/api/v1/repos/martianh/etym.el/languages")
     (html_url . "https://codeberg.org/martianh/etym.el")
     (url . "https://codeberg.org/api/v1/repos/martianh/etym.el")
     (link . "")
     (ssh_url . "ssh://git@codeberg.org/martianh/etym.el.git")
     (clone_url . "https://codeberg.org/martianh/etym.el.git")
     (original_url . "")
     (website . "")
     (stars_count . 0)
     (forks_count . 0)
     (watchers_count . 1)
     (open_issues_count . 0)
     (open_pr_counter . 0)
     (release_counter . 0)
     (default_branch . "main")
     (archived . :json-false)
     (created_at . "2023-03-22T00:05:11+01:00")
     (updated_at . "2025-08-16T13:01:54+02:00")
     (archived_at . "1970-01-01T01:00:00+01:00")
     (permissions
      (admin . t)
      (push . t)
      (pull . t))
     (has_issues . t)
     (internal_tracker
      (enable_time_tracker . t)
      (allow_only_contributors_to_track_time . t)
      (enable_issue_dependencies . t))
     (has_wiki . t)
     (wiki_branch . "master")
     (globally_editable_wiki . :json-false)
     (has_pull_requests . t)
     (has_projects . t)
     (has_releases . t)
     (has_packages . t)
     (has_actions . :json-false)
     (ignore_whitespace_conflicts . :json-false)
     (allow_merge_commits . t)
     (allow_rebase . t)
     (allow_rebase_explicit . t)
     (allow_squash_merge . t)
     (allow_fast_forward_only_merge . :json-false)
     (allow_rebase_update . t)
     (default_delete_branch_after_merge . :json-false)
     (default_merge_style . "merge")
     (default_allow_maintainer_edit . :json-false)
     (default_update_style . "merge")
     (avatar_url . "")
     (internal . :json-false)
     (mirror_interval . "")
     (object_format_name . "sha1")
     (mirror_updated . "0001-01-01T00:00:00Z")
     (repo_transfer)
     (topics "emacs" "language" "emacs-lisp" "dictionary" "english" "etymology"))
    ((id . 33641)
     (owner
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (name . "mastodon.el")
     (full_name . "martianh/mastodon.el")
     (description . "Emacs client for fediverse servers that implement the Mastodon API.")
     (empty . :json-false)
     (private . :json-false)
     (fork . :json-false)
     (template . :json-false)
     (parent)
     (mirror . :json-false)
     (size . 9156)
     (language . "Emacs Lisp")
     (languages_url . "https://codeberg.org/api/v1/repos/martianh/mastodon.el/languages")
     (html_url . "https://codeberg.org/martianh/mastodon.el")
     (url . "https://codeberg.org/api/v1/repos/martianh/mastodon.el")
     (link . "")
     (ssh_url . "ssh://git@codeberg.org/martianh/mastodon.el.git")
     (clone_url . "https://codeberg.org/martianh/mastodon.el.git")
     (original_url . "https://github.com/mooseyboots/mastodon.el")
     (website . "")
     (stars_count . 120)
     (forks_count . 32)
     (watchers_count . 10)
     (open_issues_count . 51)
     (open_pr_counter . 4)
     (release_counter . 6)
     (default_branch . "main")
     (archived . :json-false)
     (created_at . "2022-01-11T21:38:12+01:00")
     (updated_at . "2025-08-16T12:37:06+02:00")
     (archived_at . "1970-01-01T01:00:00+01:00")
     (permissions
      (admin . t)
      (push . t)
      (pull . t))
     (has_issues . t)
     (internal_tracker
      (enable_time_tracker . t)
      (allow_only_contributors_to_track_time . t)
      (enable_issue_dependencies . t))
     (has_wiki . t)
     (wiki_branch . "master")
     (globally_editable_wiki . :json-false)
     (has_pull_requests . t)
     (has_projects . t)
     (has_releases . t)
     (has_packages . :json-false)
     (has_actions . :json-false)
     (ignore_whitespace_conflicts . :json-false)
     (allow_merge_commits . t)
     (allow_rebase . t)
     (allow_rebase_explicit . t)
     (allow_squash_merge . t)
     (allow_fast_forward_only_merge . :json-false)
     (allow_rebase_update . t)
     (default_delete_branch_after_merge . :json-false)
     (default_merge_style . "merge")
     (default_allow_maintainer_edit . :json-false)
     (default_update_style . "merge")
     (avatar_url . "")
     (internal . :json-false)
     (mirror_interval . "")
     (object_format_name . "sha1")
     (mirror_updated . "0001-01-01T00:00:00Z")
     (repo_transfer)
     (topics "emacs" "fediverse" "mastodon" "activitypub" "elisp" "misskey" "akkoma"))
    ((id . 119133)
     (owner
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (name . "fedi.el")
     (full_name . "martianh/fedi.el")
     (description . "helper functions for emacs fediverse (or other REST API) clients.")
     (empty . :json-false)
     (private . :json-false)
     (fork . :json-false)
     (template . :json-false)
     (parent)
     (mirror . :json-false)
     (size . 223)
     (language . "Emacs Lisp")
     (languages_url . "https://codeberg.org/api/v1/repos/martianh/fedi.el/languages")
     (html_url . "https://codeberg.org/martianh/fedi.el")
     (url . "https://codeberg.org/api/v1/repos/martianh/fedi.el")
     (link . "")
     (ssh_url . "ssh://git@codeberg.org/martianh/fedi.el.git")
     (clone_url . "https://codeberg.org/martianh/fedi.el.git")
     (original_url . "")
     (website . "")
     (stars_count . 2)
     (forks_count . 0)
     (watchers_count . 1)
     (open_issues_count . 4)
     (open_pr_counter . 0)
     (release_counter . 0)
     (default_branch . "main")
     (archived . :json-false)
     (created_at . "2023-06-15T18:45:49+02:00")
     (updated_at . "2025-08-12T08:45:43+02:00")
     (archived_at . "1970-01-01T01:00:00+01:00")
     (permissions
      (admin . t)
      (push . t)
      (pull . t))
     (has_issues . t)
     (internal_tracker
      (enable_time_tracker . t)
      (allow_only_contributors_to_track_time . t)
      (enable_issue_dependencies . t))
     (has_wiki . t)
     (wiki_branch . "master")
     (globally_editable_wiki . :json-false)
     (has_pull_requests . t)
     (has_projects . t)
     (has_releases . t)
     (has_packages . t)
     (has_actions . :json-false)
     (ignore_whitespace_conflicts . :json-false)
     (allow_merge_commits . t)
     (allow_rebase . t)
     (allow_rebase_explicit . t)
     (allow_squash_merge . t)
     (allow_fast_forward_only_merge . :json-false)
     (allow_rebase_update . t)
     (default_delete_branch_after_merge . :json-false)
     (default_merge_style . "merge")
     (default_allow_maintainer_edit . :json-false)
     (default_update_style . "merge")
     (avatar_url . "")
     (internal . :json-false)
     (mirror_interval . "")
     (object_format_name . "sha1")
     (mirror_updated . "0001-01-01T00:00:00Z")
     (repo_transfer)
     (topics "emacs" "fediverse" "emacs-lisp" "elisp" "requests"))
    ((id . 291613)
     (owner
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (name . "gdr")
     (full_name . "martianh/gdr")
     (description . "some utils for interacting with the google drive API.")
     (empty . :json-false)
     (private . :json-false)
     (fork . :json-false)
     (template . :json-false)
     (parent)
     (mirror . :json-false)
     (size . 119)
     (language . "Emacs Lisp")
     (languages_url . "https://codeberg.org/api/v1/repos/martianh/gdr/languages")
     (html_url . "https://codeberg.org/martianh/gdr")
     (url . "https://codeberg.org/api/v1/repos/martianh/gdr")
     (link . "")
     (ssh_url . "ssh://git@codeberg.org/martianh/gdr.git")
     (clone_url . "https://codeberg.org/martianh/gdr.git")
     (original_url . "")
     (website . "")
     (stars_count . 1)
     (forks_count . 0)
     (watchers_count . 1)
     (open_issues_count . 11)
     (open_pr_counter . 0)
     (release_counter . 0)
     (default_branch . "main")
     (archived . :json-false)
     (created_at . "2024-12-16T18:45:28+01:00")
     (updated_at . "2025-08-11T17:48:42+02:00")
     (archived_at . "1970-01-01T01:00:00+01:00")
     (permissions
      (admin . t)
      (push . t)
      (pull . t))
     (has_issues . t)
     (internal_tracker
      (enable_time_tracker . t)
      (allow_only_contributors_to_track_time . t)
      (enable_issue_dependencies . t))
     (has_wiki . :json-false)
     (wiki_branch . "main")
     (globally_editable_wiki . :json-false)
     (has_pull_requests . t)
     (has_projects . :json-false)
     (has_releases . :json-false)
     (has_packages . :json-false)
     (has_actions . :json-false)
     (ignore_whitespace_conflicts . :json-false)
     (allow_merge_commits . t)
     (allow_rebase . t)
     (allow_rebase_explicit . t)
     (allow_squash_merge . t)
     (allow_fast_forward_only_merge . t)
     (allow_rebase_update . t)
     (default_delete_branch_after_merge . :json-false)
     (default_merge_style . "merge")
     (default_allow_maintainer_edit . :json-false)
     (default_update_style . "merge")
     (avatar_url . "")
     (internal . :json-false)
     (mirror_interval . "")
     (object_format_name . "sha1")
     (mirror_updated . "0001-01-01T00:00:00Z")
     (repo_transfer)
     (topics "cloud" "elisp" "emacs" "gdrive"))))

(defvar fj-test-issues
  ;; (fj-repo-get-issues "fj.el" nil nil nil nil nil nil "1" "5")
  '(((id . 2188090)
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/issues/208")
     (html_url . "https://codeberg.org/martianh/fj.el/issues/208")
     (number . 208)
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "mousebot@disroot.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "en-US")
      (is_admin . :json-false)
      (last_login . "2024-11-21T14:09:25+01:00")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . t)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (title . "browse watched repos?")
     (body . "i can't see the URL for one's watched repos on the web UI...")
     (ref . "")
     (assets)
     (labels)
     (milestone)
     (assignee)
     (assignees)
     (state . "open")
     (is_locked . :json-false)
     (comments . 0)
     (created_at . "2025-08-17T13:00:42+02:00")
     (updated_at . "2025-08-17T13:00:42+02:00")
     (closed_at)
     (due_date)
     (pull_request)
     (repository
      (id . 142698)
      (name . "fj.el")
      (owner . "martianh")
      (full_name . "martianh/fj.el"))
     (pin_order . 0))
    ((id . 1829436)
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/issues/164")
     (html_url . "https://codeberg.org/martianh/fj.el/issues/164")
     (number . 164)
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "mousebot@disroot.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "en-US")
      (is_admin . :json-false)
      (last_login . "2024-11-21T14:09:25+01:00")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . t)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (title . "repo view")
     (body . "did we have an issue for this and lose it?

repo view could include:

- name
- owner
- desccription
- topics
- url
- size
- lang
- stats (forks, stars, watchers)
- issues / prs
- releases
- fork status
")
     (ref . "")
     (assets)
     (labels)
     (milestone)
     (assignee)
     (assignees)
     (state . "open")
     (is_locked . :json-false)
     (comments . 4)
     (created_at . "2025-06-16T14:09:52+02:00")
     (updated_at . "2025-08-16T13:41:23+02:00")
     (closed_at)
     (due_date)
     (pull_request)
     (repository
      (id . 142698)
      (name . "fj.el")
      (owner . "martianh")
      (full_name . "martianh/fj.el"))
     (pin_order . 0))
    ((id . 2004949)
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/issues/206")
     (html_url . "https://codeberg.org/martianh/fj.el/issues/206")
     (number . 206)
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "mousebot@disroot.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "en-US")
      (is_admin . :json-false)
      (last_login . "2024-11-21T14:09:25+01:00")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . t)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (title . "render links to range of lines in source text as code")
     (body . "e.g. https://codeberg.org/martianh/fj.el/src/dev/fj.el#L105-L111

(created by git-link package)")
     (ref . "")
     (assets)
     (labels)
     (milestone)
     (assignee)
     (assignees)
     (state . "open")
     (is_locked . :json-false)
     (comments . 17)
     (created_at . "2025-08-06T09:45:17+02:00")
     (updated_at . "2025-08-16T09:12:15+02:00")
     (closed_at)
     (due_date)
     (pull_request)
     (repository
      (id . 142698)
      (name . "fj.el")
      (owner . "martianh")
      (full_name . "martianh/fj.el"))
     (pin_order . 0))
    ((id . 1996549)
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/issues/196")
     (html_url . "https://codeberg.org/martianh/fj.el/issues/196")
     (number . 196)
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "mousebot@disroot.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "en-US")
      (is_admin . :json-false)
      (last_login . "2024-11-21T14:09:25+01:00")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . t)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (title . "viewing commits: display desc as well as diff")
     (body . "e.g. clicking on timeline commit-refs loads a diff only.")
     (ref . "")
     (assets)
     (labels)
     (milestone)
     (assignee)
     (assignees)
     (state . "open")
     (is_locked . :json-false)
     (comments . 4)
     (created_at . "2025-08-02T11:30:43+02:00")
     (updated_at . "2025-08-09T11:38:34+02:00")
     (closed_at)
     (due_date)
     (pull_request)
     (repository
      (id . 142698)
      (name . "fj.el")
      (owner . "martianh")
      (full_name . "martianh/fj.el"))
     (pin_order . 0))
    ((id . 2000974)
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/issues/204")
     (html_url . "https://codeberg.org/martianh/fj.el/issues/204")
     (number . 204)
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "mousebot@disroot.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "en-US")
      (is_admin . :json-false)
      (last_login . "2024-11-21T14:09:25+01:00")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . t)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (title . "list issues repo prompt broken if wanted repo is not in 50 returned")
     (body . "do we need a dynamic completion engine that searches as you type")
     (ref . "")
     (assets)
     (labels)
     (milestone)
     (assignee)
     (assignees)
     (state . "open")
     (is_locked . :json-false)
     (comments . 1)
     (created_at . "2025-08-04T14:16:04+02:00")
     (updated_at . "2025-08-09T11:37:12+02:00")
     (closed_at)
     (due_date)
     (pull_request)
     (repository
      (id . 142698)
      (name . "fj.el")
      (owner . "martianh")
      (full_name . "martianh/fj.el"))
     (pin_order . 0))))

(defvar fj-test-comments
  ;; (fj-issue-get-comments "fj.el" "martianh" "101")
  '(((id . 3086223)
     (html_url . "https://codeberg.org/martianh/fj.el/issues/101#issuecomment-3086223")
     (pull_request_url . "")
     (issue_url . "https://codeberg.org/martianh/fj.el/issues/101")
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (body . "i'm somehow not confident that the fixed version will end up in codeberg.

let's check after the next Forgejo release cycle and if its not fixed we open an issue.")
     (assets)
     (created_at . "2025-03-18T11:19:13+01:00")
     (updated_at . "2025-03-18T11:19:13+01:00"))
    ((id . 3086236)
     (html_url . "https://codeberg.org/martianh/fj.el/issues/101#issuecomment-3086236")
     (pull_request_url . "")
     (issue_url . "https://codeberg.org/martianh/fj.el/issues/101")
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (body . "looks like codeberg runs version 10 https://codeberg.org/Codeberg-Infrastructure/forgejo/releases/tag/v10.0.0")
     (assets)
     (created_at . "2025-03-18T11:31:06+01:00")
     (updated_at . "2025-03-18T11:31:06+01:00"))
    ((id . 3086253)
     (html_url . "https://codeberg.org/martianh/fj.el/issues/101#issuecomment-3086253")
     (pull_request_url . "")
     (issue_url . "https://codeberg.org/martianh/fj.el/issues/101")
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (body . "ah, next version is specified in the next forgejo url above. so yes, let's wait for v 11.")
     (assets)
     (created_at . "2025-03-18T11:40:23+01:00")
     (updated_at . "2025-03-18T11:40:23+01:00"))
    ((id . 3840056)
     (html_url . "https://codeberg.org/martianh/fj.el/issues/101#issuecomment-3840056")
     (pull_request_url . "")
     (issue_url . "https://codeberg.org/martianh/fj.el/issues/101")
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (body . "v11 released:

https://codeberg.org/forgejo/forgejo/src/branch/forgejo/release-notes-published/11.0.0.md

(still waiting for codeberg to update...)")
     (assets)
     (created_at . "2025-04-17T09:52:25+02:00")
     (updated_at . "2025-04-17T09:52:25+02:00"))
    ((id . 4992771)
     (html_url . "https://codeberg.org/martianh/fj.el/issues/101#issuecomment-4992771")
     (pull_request_url . "")
     (issue_url . "https://codeberg.org/martianh/fj.el/issues/101")
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (body . "currently it seems to work provided we type 4-5 letters at least. it's also awfully slow. i also suspect Codeberg is still fuzzy searching, as an API search for mart returns usernames all starting with A.")
     (assets)
     (created_at . "2025-06-04T10:12:04+02:00")
     (updated_at . "2025-06-04T10:12:04+02:00"))
    ((id . 4992777)
     (html_url . "https://codeberg.org/martianh/fj.el/issues/101#issuecomment-4992777")
     (pull_request_url . "")
     (issue_url . "https://codeberg.org/martianh/fj.el/issues/101")
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (body . "to improve it then, looks like we'd have to ask Codeberg about it.")
     (assets)
     (created_at . "2025-06-04T10:13:12+02:00")
     (updated_at . "2025-06-04T10:13:12+02:00"))
    ((id . 5804357)
     (html_url . "https://codeberg.org/martianh/fj.el/issues/101#issuecomment-5804357")
     (pull_request_url . "")
     (issue_url . "https://codeberg.org/martianh/fj.el/issues/101")
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (body . "the issue remains the same, it works for names near start of alphabet only.

the webUI only completes names in the issue.")
     (assets)
     (created_at . "2025-07-12T21:46:03+02:00")
     (updated_at . "2025-07-13T12:19:33+02:00"))
    ((id . 5808110)
     (html_url . "https://codeberg.org/martianh/fj.el/issues/101#issuecomment-5808110")
     (pull_request_url . "")
     (issue_url . "https://codeberg.org/martianh/fj.el/issues/101")
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (body . "gitnex implements full instance user completion, unlike ours, it displays 'matches' even if they don't start with the chars typed. can we do that...?")
     (assets)
     (created_at . "2025-07-13T12:22:48+02:00")
     (updated_at . "2025-07-13T12:22:48+02:00"))
    ((id . 5810279)
     (html_url . "https://codeberg.org/martianh/fj.el/issues/101#issuecomment-5810279")
     (pull_request_url . "")
     (issue_url . "https://codeberg.org/martianh/fj.el/issues/101")
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (body . "asked on forgejo: https://codeberg.org/forgejo/forgejo/issues/8499")
     (assets)
     (created_at . "2025-07-13T16:57:25+02:00")
     (updated_at . "2025-07-13T16:57:25+02:00"))
    ((id . 5826602)
     (html_url . "https://codeberg.org/martianh/fj.el/issues/101#issuecomment-5826602")
     (pull_request_url . "")
     (issue_url . "https://codeberg.org/martianh/fj.el/issues/101")
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (body . "minad confirmed that dynamic completion mandates prefix completion (not substring/orderless styles), so we also can't get a pop up showing even the wrong results...")
     (assets)
     (created_at . "2025-07-14T18:19:52+02:00")
     (updated_at . "2025-07-14T18:19:52+02:00"))
    ((id . 5983591)
     (html_url . "https://codeberg.org/martianh/fj.el/issues/101#issuecomment-5983591")
     (pull_request_url . "")
     (issue_url . "https://codeberg.org/martianh/fj.el/issues/101")
     (user
      (id . 36599)
      (login . "martianh")
      (login_name . "")
      (source_id . 0)
      (full_name . "")
      (email . "martianh@noreply.codeberg.org")
      (avatar_url . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
      (html_url . "https://codeberg.org/martianh")
      (language . "")
      (is_admin . :json-false)
      (last_login . "0001-01-01T00:00:00Z")
      (created . "2021-12-22T10:45:50+01:00")
      (restricted . :json-false)
      (active . :json-false)
      (prohibit_login . :json-false)
      (location . "local group")
      (pronouns . "he/him or they/them")
      (website . "https://anarchive.mooo.com")
      (description . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
      (visibility . "public")
      (followers_count . 26)
      (following_count . 66)
      (starred_repos_count . 82)
      (username . "martianh"))
     (original_author . "")
     (original_author_id . 0)
     (body . "sort param for user/search endpoint is merged, coming in forgejo v13.")
     (assets)
     (created_at . "2025-07-25T08:08:00+02:00")
     (updated_at . "2025-07-25T08:08:00+02:00"))))

(defvar fj-test-repo-labels
  ;; (fj-repo-get-labels "fj.el" "martianh")
  '(((id . 456275)
     (name . "api")
     (exclusive . :json-false)
     (is_archived . :json-false)
     (color . "ee9a49")
     (description . "")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/labels/456275"))
    ((id . 456278)
     (name . "api")
     (exclusive . :json-false)
     (is_archived . :json-false)
     (color . "ee9a49")
     (description . "")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/labels/456278"))
    ((id . 456281)
     (name . "api")
     (exclusive . :json-false)
     (is_archived . :json-false)
     (color . "ee9a49")
     (description . "")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/labels/456281"))
    ((id . 259827)
     (name . "bug")
     (exclusive . :json-false)
     (is_archived . :json-false)
     (color . "ee0701")
     (description . "Something is not working")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/labels/259827"))
    ((id . 259831)
     (name . "contribution welcome")
     (exclusive . :json-false)
     (is_archived . :json-false)
     (color . "128a0c")
     (description . "Contributions are very welcome, get started here")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/labels/259831"))
    ((id . 259828)
     (name . "duplicate")
     (exclusive . :json-false)
     (is_archived . :json-false)
     (color . "cccccc")
     (description . "This issue or pull request already exists")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/labels/259828"))
    ((id . 259829)
     (name . "enhancement")
     (exclusive . :json-false)
     (is_archived . :json-false)
     (color . "84b6eb")
     (description . "New feature")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/labels/259829"))
    ((id . 259835)
     (name . "good first issue")
     (exclusive . :json-false)
     (is_archived . :json-false)
     (color . "53e917")
     (description . "Interested in contributing? Get started here.")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/labels/259835"))
    ((id . 259830)
     (name . "help wanted")
     (exclusive . :json-false)
     (is_archived . :json-false)
     (color . "eb6420")
     (description . "Need some help")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/labels/259830"))
    ((id . 259832)
     (name . "invalid")
     (exclusive . :json-false)
     (is_archived . :json-false)
     (color . "e6e6e6")
     (description . "Something is wrong")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/labels/259832"))
    ((id . 259833)
     (name . "question")
     (exclusive . :json-false)
     (is_archived . :json-false)
     (color . "cc317c")
     (description . "More information is needed")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/labels/259833"))
    ((id . 259834)
     (name . "upstream")
     (exclusive . :json-false)
     (is_archived . :json-false)
     (color . "0052cc")
     (description . "Related to an upstream repository, already reported there")
     (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/labels/259834"))))

(defvar fj-test-issue-tl-entry
  '(nil
    [("164" id 1829436 state "open" type fj-issue-button item issue fj-url
      "https://codeberg.org/martianh/fj.el/issues/164" fj-item-data
      ((id . 1829436)
       (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/issues/164")
       (html_url . "https://codeberg.org/martianh/fj.el/issues/164")
       (number . 164)
       (user (id . 36599) (login . "martianh") (login_name . "")
             (source_id . 0) (full_name . "") (email . "mousebot@disroot.org")
             (avatar_url
              . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
             (html_url . "https://codeberg.org/martianh") (language . "en-US")
             (is_admin . :json-false)
             (last_login . "2024-11-21T14:09:25+01:00")
             (created . "2021-12-22T10:45:50+01:00")
             (restricted . :json-false) (active . t)
             (prohibit_login . :json-false) (location . "local group")
             (pronouns . "he/him or they/them")
             (website . "https://anarchive.mooo.com")
             (description
              . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
             (visibility . "public") (followers_count . 26)
             (following_count . 66) (starred_repos_count . 82)
             (username . "martianh"))
       (original_author . "") (original_author_id . 0) (title . "repo view")
       (body
        . "did we have an issue for this and lose it?\n\nrepo view could include:\n\n- name\n- owner\n- desccription\n- topics\n- url\n- size\n- lang\n- stats (forks, stars, watchers)\n- issues / prs\n- releases\n- fork status\n")
       (ref . "") (assets) (labels) (milestone) (assignee) (assignees)
       (state . "open") (is_locked . :json-false) (comments . 4)
       (created_at . "2025-06-16T14:09:52+02:00")
       (updated_at . "2025-08-16T13:41:23+02:00") (closed_at) (due_date)
       (pull_request)
       (repository (id . 142698) (name . "fj.el") (owner . "martianh")
                   (full_name . "martianh/fj.el"))
       (pin_order . 0))
      fj-tab-stop t)
     ("4" face fj-figures-face item issue)
     ("martianh" face fj-user-face id 1829436 state "open" type
      fj-issues-owner-button item issue fj-tab-stop t)
     ("1755344483" display "23 hours ago" face default item issue)
     (#("repo view " 0 9 (face fj-item-face) 9 10 (face default)) id 1829436
      state "open" type fj-issue-button fj-item-data
      ((id . 1829436)
       (url . "https://codeberg.org/api/v1/repos/martianh/fj.el/issues/164")
       (html_url . "https://codeberg.org/martianh/fj.el/issues/164")
       (number . 164)
       (user (id . 36599) (login . "martianh") (login_name . "")
             (source_id . 0) (full_name . "") (email . "mousebot@disroot.org")
             (avatar_url
              . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
             (html_url . "https://codeberg.org/martianh") (language . "en-US")
             (is_admin . :json-false)
             (last_login . "2024-11-21T14:09:25+01:00")
             (created . "2021-12-22T10:45:50+01:00")
             (restricted . :json-false) (active . t)
             (prohibit_login . :json-false) (location . "local group")
             (pronouns . "he/him or they/them")
             (website . "https://anarchive.mooo.com")
             (description
              . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
             (visibility . "public") (followers_count . 26)
             (following_count . 66) (starred_repos_count . 82)
             (username . "martianh"))
       (original_author . "") (original_author_id . 0) (title . "repo view")
       (body
        . "did we have an issue for this and lose it?\n\nrepo view could include:\n\n- name\n- owner\n- desccription\n- topics\n- url\n- size\n- lang\n- stats (forks, stars, watchers)\n- issues / prs\n- releases\n- fork status\n")
       (ref . "") (assets) (labels) (milestone) (assignee) (assignees)
       (state . "open") (is_locked . :json-false) (comments . 4)
       (created_at . "2025-06-16T14:09:52+02:00")
       (updated_at . "2025-08-16T13:41:23+02:00") (closed_at) (due_date)
       (pull_request)
       (repository (id . 142698) (name . "fj.el") (owner . "martianh")
                   (full_name . "martianh/fj.el"))
       (pin_order . 0))
      item issue)]))

(defvar fj-test-viewargs
  '(:repo "fj.el" :owner "martianh" :state "open" :type "issues"
          :query nil :labels nil :milestones nil :page nil :limit nil))

(defvar fj-test-viewargs-page1
  '(:repo "fj.el" :owner "martianh" :state "open" :type "issues"
          :query nil :labels nil :milestones nil :page "1" :limit nil))

(defvar fj-test-viewargs-page2
  '(:repo "fj.el" :owner "martianh" :state "open" :type "issues"
          :query nil :labels nil :milestones nil :page "2" :limit nil))

(exemplify-ert fj-test-map-alist-to-cons
  (fj--map-alist-to-cons fj-test-repo-labels 'name 'id)
  => '(("api" . 456275) ("api" . 456278) ("api" . 456281) ("bug" . 259827)
       ("contribution welcome" . 259831) ("duplicate" . 259828)
       ("enhancement" . 259829) ("good first issue" . 259835)
       ("help wanted" . 259830) ("invalid" . 259832) ("question" . 259833)
       ("upstream" . 259834)))

(exemplify-ert fj-test-map-alist-key
  (fj--map-alist-key fj-test-repo-labels 'id)
  => '(456275 456278 456281 259827 259831 259828 259829 259835 259830 259832
              259833 259834))

(exemplify-ert fj-test-plist-values
  (fj-plist-values fj-test-viewargs)
  => '("fj.el" "martianh" "open" "issues" nil nil nil nil nil))

(exemplify-ert fj-test-dec-page
  (fj-dec-plist-page fj-test-viewargs)
  => '(:repo "fj.el" :owner "martianh" :state "open" :type "issues" :query nil
             :labels nil :milestones nil :page nil :limit nil)
  (fj-dec-plist-page fj-test-viewargs-page1)
  => '(:repo "fj.el" :owner "martianh" :state "open" :type "issues" :query nil
             :labels nil :milestones nil :page "0" :limit nil)
  (fj-dec-plist-page fj-test-viewargs-page2)
  => '(:repo "fj.el" :owner "martianh" :state "open" :type "issues" :query nil
             :labels nil :milestones nil :page "1" :limit nil))

(exemplify-ert fj-test-inc-page
  (fj-inc-plist-page fj-test-viewargs)
  => '(:repo "fj.el" :owner "martianh" :state "open" :type "issues" :query nil
             :labels nil :milestones nil :page "2" :limit nil)
  (fj-inc-plist-page fj-test-viewargs-page1)
  => '(:repo "fj.el" :owner "martianh" :state "open" :type "issues" :query nil
             :labels nil :milestones nil :page "2" :limit nil)
  (fj-inc-plist-page fj-test-viewargs-page2)
  => '(:repo "fj.el" :owner "martianh" :state "open" :type "issues" :query nil
             :labels nil :milestones nil :page "3" :limit nil))

(exemplify-ert fj-test-get-elt
  (fj--tl-get-elt 0 fj-test-issue-tl-entry) => "164"
  (fj--tl-get-elt 1 fj-test-issue-tl-entry) => "4"
  (fj--tl-get-elt 2 fj-test-issue-tl-entry) => "martianh"
  ;; timestamp:
  (fj--tl-get-elt 3 fj-test-issue-tl-entry) => "1755344483"
  (fj--tl-get-elt 4 fj-test-issue-tl-entry)
  => #("repo view " 0 9 (face fj-item-face) 9 10 (face default)))

;; TODO: mock up a loaded TL view
;; TODO: mock up a loaded timeline view
;; TODO: test that for a given view, view fun arity = view args

(exemplify-ert fj-test-repo-cands
  (fj-get-repo-candidates fj-test-repos)
  => '(("fj.el" 142698
        "An Emacs client for Forgejo instances (such as Codeberg)." "martianh")
       ("etym.el" 101093 "Basic interface to https://etymonline.com in Emacs."
        "martianh")
       ("mastodon.el" 33641
        "Emacs client for fediverse servers that implement the Mastodon API."
        "martianh")
       ("fedi.el" 119133
        "helper functions for emacs fediverse (or other REST API) clients."
        "martianh")
       ("gdr" 291613 "some utils for interacting with the google drive API."
        "martianh")))

(exemplify-ert fj-test-item-cands
  (fj-get-item-candidates fj-test-issues)
  => '(("browse watched repos?" 208 2188090) ("repo view" 164 1829436)
       ("render links to range of lines in source text as code" 206 2004949)
       ("viewing commits: display desc as well as diff" 196 1996549)
       ("list issues repo prompt broken if wanted repo is not in 50 returned"
        204 2000974)))

(defvar fj-issues-search-viewargs
  '(:repo "fj.el" :owner "martianh" :state "all" :type "issues" :query
          "broken" :labels nil :milestones nil :page nil :limit nil))

(exemplify-ert fj-next-plist-state
  (fj-next-plist-state
   fj-issues-search-viewargs :owner :created)
  => '(:repo "fj.el" :owner nil :state "all" :type "issues" :query "broken"
             :labels nil :milestones nil :page nil :limit nil :created t)
  (fj-next-plist-state
   '(:repo "fj.el" :owner nil :state "all" :type "issues" :query "broken"
           :labels nil :milestones nil :page nil :limit nil :created t)
   :created :mentioned)
  => '(:repo "fj.el" :owner nil :state "all" :type "issues" :query "broken"
             :labels nil :milestones nil :page nil :limit nil :created nil
             :mentioned t)
  (fj-next-plist-state
   '(:repo "fj.el" :owner nil :state "all" :type "issues" :query "broken"
           :labels nil :milestones nil :page nil :limit nil :created nil
           :mentioned t)
   :mentioned :assigned)
  => '(:repo "fj.el" :owner nil :state "all" :type "issues" :query "broken"
             :labels nil :milestones nil :page nil :limit nil :created nil
             :mentioned nil :assigned t)
  (fj-next-plist-state
   '(:repo "fj.el" :owner nil :state "all" :type "issues" :query "broken"
           :labels nil :milestones nil :page nil :limit nil :created nil
           :mentioned nil :assigned t)
   :assigned :owner "martianh")
  => '(:repo "fj.el" :owner "martianh" :state "all" :type "issues" :query
             "broken" :labels nil :milestones nil :page nil :limit nil :created
             nil :mentioned nil :assigned nil))

(exemplify-ert fj-test-comment-cands
  (fj-get-comment-candidates fj-test-comments)
  => '(("i'm somehow not confident that the fixed version will end up in codebe"
        3086223)
       ("looks like codeberg runs version 10 https://codeberg.org/Codeberg-Infr"
        3086236)
       ("ah, next version is specified in the next forgejo url above. so yes, l"
        3086253)
       ("v11 released: https://codeberg.org/forgejo/forgejo/src/branch/forgejo"
        3840056)
       ("currently it seems to work provided we type 4-5 letters at least. it's"
        4992771)
       ("to improve it then, looks like we'd have to ask Codeberg about it."
        4992777)
       ("the issue remains the same, it works for names near start of alphabet"
        5804357)
       ("gitnex implements full instance user completion, unlike ours, it displ"
        5808110)
       ("asked on forgejo: https://codeberg.org/forgejo/forgejo/issues/8499"
        5810279)
       ("minad confirmed that dynamic completion mandates prefix completion (no"
        5826602)
       ("sort param for user/search endpoint is merged, coming in forgejo v13."
        5983591)))

(defvar fj-test-reactions
  ;; (fj-get-comment-reactions "2320940" "fj.el" "martianh")
  '(((user (id . 36599) (login . "martianh") (login_name . "")
           (source_id . 0) (full_name . "") (email . "mousebot@disroot.org")
           (avatar_url
            . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
           (html_url . "https://codeberg.org/martianh") (language . "en-US")
           (is_admin . :json-false)
           (last_login . "2024-11-21T14:09:25+01:00")
           (created . "2021-12-22T10:45:50+01:00") (restricted . :json-false)
           (active . t) (prohibit_login . :json-false)
           (location . "local group") (pronouns . "he/him or they/them")
           (website . "https://anarchive.mooo.com")
           (description
            . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
           (visibility . "public") (followers_count . 26)
           (following_count . 66) (starred_repos_count . 82)
           (username . "martianh"))
     (content . "hooray") (created_at . "2024-12-19T10:25:02+01:00"))
    ((user (id . 36599) (login . "martianh") (login_name . "")
           (source_id . 0) (full_name . "") (email . "mousebot@disroot.org")
           (avatar_url
            . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
           (html_url . "https://codeberg.org/martianh") (language . "en-US")
           (is_admin . :json-false)
           (last_login . "2024-11-21T14:09:25+01:00")
           (created . "2021-12-22T10:45:50+01:00") (restricted . :json-false)
           (active . t) (prohibit_login . :json-false)
           (location . "local group") (pronouns . "he/him or they/them")
           (website . "https://anarchive.mooo.com")
           (description
            . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
           (visibility . "public") (followers_count . 26)
           (following_count . 66) (starred_repos_count . 82)
           (username . "martianh"))
     (content . "eyes") (created_at . "2024-12-19T10:28:38+01:00"))
    ((user (id . 36599) (login . "martianh") (login_name . "")
           (source_id . 0) (full_name . "") (email . "mousebot@disroot.org")
           (avatar_url
            . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
           (html_url . "https://codeberg.org/martianh") (language . "en-US")
           (is_admin . :json-false)
           (last_login . "2024-11-21T14:09:25+01:00")
           (created . "2021-12-22T10:45:50+01:00") (restricted . :json-false)
           (active . t) (prohibit_login . :json-false)
           (location . "local group") (pronouns . "he/him or they/them")
           (website . "https://anarchive.mooo.com")
           (description
            . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
           (visibility . "public") (followers_count . 26)
           (following_count . 66) (starred_repos_count . 82)
           (username . "martianh"))
     (content . "heart") (created_at . "2025-03-19T14:24:04+01:00"))))

(exemplify-ert fj-test-render-comment-reactions
  (fj-group-reactions fj-test-reactions)
  => '(("hooray" "martianh") ("eyes" "martianh") ("heart" "martianh"))
  (fj-render-comment-reactions fj-test-reactions)
  => #("――――――――――――――――
:hooray: 1 :eyes: 1 :heart: 1"
       25 27 (help-echo "martianh" face fj-user-face)
       34 36 (help-echo "martianh" face fj-user-face)
       44 46 (help-echo "martianh" face fj-user-face)))

(exemplify-ert fj-test-prop-labels
  (fj-propertize-label-names fj-test-repo-labels)
  => '((#("api" 0 3
          (face
           (:inherit fj-label-face :background "#ee9a49" :foreground "black")
           help-echo ""))
        . 456275)
       (#("api" 0 3
          (face
           (:inherit fj-label-face :background "#ee9a49" :foreground "black")
           help-echo ""))
        . 456278)
       (#("api" 0 3
          (face
           (:inherit fj-label-face :background "#ee9a49" :foreground "black")
           help-echo ""))
        . 456281)
       (#("bug" 0 3
          (face
           (:inherit fj-label-face :background "#ee0701" :foreground "#ffffff")
           help-echo "Something is not working"))
        . 259827)
       (#("contribution welcome" 0 20
          (face
           (:inherit fj-label-face :background "#128a0c" :foreground "#ffffff")
           help-echo "Contributions are very welcome, get started here"))
        . 259831)
       (#("duplicate" 0 9
          (face
           (:inherit fj-label-face :background "#cccccc" :foreground "black")
           help-echo "This issue or pull request already exists"))
        . 259828)
       (#("enhancement" 0 11
          (face
           (:inherit fj-label-face :background "#84b6eb" :foreground "black")
           help-echo "New feature"))
        . 259829)
       (#("good first issue" 0 16
          (face
           (:inherit fj-label-face :background "#53e917" :foreground "black")
           help-echo "Interested in contributing? Get started here."))
        . 259835)
       (#("help wanted" 0 11
          (face
           (:inherit fj-label-face :background "#eb6420" :foreground "#ffffff")
           help-echo "Need some help"))
        . 259830)
       (#("invalid" 0 7
          (face
           (:inherit fj-label-face :background "#e6e6e6" :foreground "black")
           help-echo "Something is wrong"))
        . 259832)
       (#("question" 0 8
          (face
           (:inherit fj-label-face :background "#cc317c" :foreground "#ffffff")
           help-echo "More information is needed"))
        . 259833)
       (#("upstream" 0 8
          (face
           (:inherit fj-label-face :background "#0052cc" :foreground "#ffffff")
           help-echo "Related to an upstream repository, already reported there"))
        . 259834))
  (fj-propertize-labels fj-test-repo-labels)
  => #("api api api bug contribution welcome duplicate enhancement good first issue help wanted invalid question upstream"
       0 3
       (help-echo "" face
                  (:inherit fj-label-face :background "#ee9a49" :foreground
                            "black"))
       3 4 (face default) 4 7
       (help-echo "" face
                  (:inherit fj-label-face :background "#ee9a49" :foreground
                            "black"))
       7 8 (face default) 8 11
       (help-echo "" face
                  (:inherit fj-label-face :background "#ee9a49" :foreground
                            "black"))
       11 12 (face default) 12 15
       (help-echo "Something is not working" face
                  (:inherit fj-label-face :background "#ee0701" :foreground
                            "#ffffff"))
       15 16 (face default) 16 36
       (help-echo "Contributions are very welcome, get started here" face
                  (:inherit fj-label-face :background "#128a0c" :foreground
                            "#ffffff"))
       36 37 (face default) 37 46
       (help-echo "This issue or pull request already exists" face
                  (:inherit fj-label-face :background "#cccccc" :foreground
                            "black"))
       46 47 (face default) 47 58
       (help-echo "New feature" face
                  (:inherit fj-label-face :background "#84b6eb" :foreground
                            "black"))
       58 59 (face default) 59 75
       (help-echo "Interested in contributing? Get started here." face
                  (:inherit fj-label-face :background "#53e917" :foreground
                            "black"))
       75 76 (face default) 76 87
       (help-echo "Need some help" face
                  (:inherit fj-label-face :background "#eb6420" :foreground
                            "#ffffff"))
       87 88 (face default) 88 95
       (help-echo "Something is wrong" face
                  (:inherit fj-label-face :background "#e6e6e6" :foreground
                            "black"))
       95 96 (face default) 96 104
       (help-echo "More information is needed" face
                  (:inherit fj-label-face :background "#cc317c" :foreground
                            "#ffffff"))
       104 105 (face default) 105 113
       (help-echo "Related to an upstream repository, already reported there"
                  face
                  (:inherit fj-label-face :background "#0052cc" :foreground
                            "#ffffff")))

  (fj-label-color-from-name
   "bug" (fj-propertize-label-names fj-test-repo-labels))
  => "#ee0701")


(defvar fj-test-milestones
  ;; (fj-get-milestones "fj.el" "martianh")
  '(((id . 15356) (title . "0.5") (description . "") (state . "open")
     (open_issues . 0) (closed_issues . 5)
     (created_at . "2025-04-06T15:26:15+02:00")
     (updated_at . "2025-04-07T20:50:57+02:00") (closed_at) (due_on))))


(exemplify-ert fj-test-next-item-var
  (fj-next-item-var "issues" fj-items-types) => "pulls"
  (fj-next-item-var "pulls" fj-items-types) => "all"
  (fj-next-item-var "open" fj-items-states) => "closed"
  (fj-next-item-var "all" fj-items-states) => "open")

(exemplify-ert fj-test-state-plist-cycle
  (fj-next-item-state-plist fj-test-viewargs)
  ;; (:repo "fj.el" :owner "martianh" :state "open" :type "issues" :query nil
  ;;        :labels nil :milestones nil :page nil :limit nil)
  => '(:repo "fj.el" :owner "martianh" :state "closed" :type "issues" :query nil
             :labels nil :milestones nil :page nil :limit nil)
  (fj-next-item-type-plist fj-test-viewargs)
  => '(:repo "fj.el" :owner "martianh" :state "open" :type "pulls" :query nil
             :labels nil :milestones nil :page nil :limit nil))

(defvar fj-test-timeline-comment
  ;; (cadr (fj-issue-get-timeline "fj.el" "martianh" "164"))
  '((id . 5465076) (type . "comment")
    (html_url
     . "https://codeberg.org/martianh/fj.el/issues/164#issuecomment-5465076")
    (pull_request_url . "")
    (issue_url . "https://codeberg.org/martianh/fj.el/issues/164")
    (user (id . 36599) (login . "martianh") (login_name . "") (source_id . 0)
          (full_name . "") (email . "martianh@noreply.codeberg.org")
          (avatar_url
           . "https://codeberg.org/avatars/f2bfe793b009b03283e12089adfdc5ae7cd215f5435f2d3734c44cad831c84e6")
          (html_url . "https://codeberg.org/martianh") (language . "")
          (is_admin . :json-false) (last_login . "0001-01-01T00:00:00Z")
          (created . "2021-12-22T10:45:50+01:00") (restricted . :json-false)
          (active . :json-false) (prohibit_login . :json-false)
          (location . "local group") (pronouns . "he/him or they/them")
          (website . "https://anarchive.mooo.com")
          (description
           . "If you appreciate my packages, please consider making a donation: https://paypal.me/martianh, https://liberapay.com/martianh/donate.")
          (visibility . "public") (followers_count . 26)
          (following_count . 66) (starred_repos_count . 82)
          (username . "martianh"))
    (body
     . "it could also serve as destination of the fork-jump-to-parent cmd.")
    (created_at . "2025-06-18T13:25:18+02:00")
    (updated_at . "2025-06-18T13:25:18+02:00") (old_project_id . 0)
    (project_id . 0) (old_milestone) (milestone) (tracked_time)
    (old_title . "") (new_title . "") (old_ref . "") (new_ref . "")
    (ref_issue) (ref_comment) (ref_action . "none") (ref_commit_sha . "")
    (review_id . 0) (label) (assignee) (assignee_team)
    (removed_assignee . :json-false) (resolve_doer) (dependent_issue)))

(exemplify-ert fj-test-format-comment-header
  (let-alist fj-test-timeline-comment
    ;; test comment header:
    (fj-format-comment-header
     ;; FIXME: test author / edited args (from buf-spec):
     .user.username nil nil
     (fj-edited-str-maybe .created_at .updated_at)
     (fedi--relative-time-description
      (date-to-time .created_at)))
    => #("martianh   9 weeks ago" 0 8
         (item "martianh" type handle follow-link t mouse-face highlight button t
               keymap
               (keymap (mouse-2 . fj-do-link-action-mouse)
                       (return . fj-do-link-action))
               fj-tab-stop t fj-byline t face fj-item-author-face)
         8 9 (face fj-item-byline-face) 9 10 (face fj-item-byline-face) 10 11
         (display (space :align-to (- right 15)) face fj-item-byline-face) 11 22
         (face fj-item-byline-face))))

(exemplify-ert fj-test-format-comment
  ;; test comment:
  (substring-no-properties
   ;; properties are nuts/fragemented due to inclusion of header!
   (fj-format-comment "fj.el" "martianh" fj-test-timeline-comment))
  => "martianh  owner 9 weeks ago\n\n\n<p dir=\"auto\">it could also serve as destination of the fork-jump-to-parent cmd.</p>\n\n――――――――――――――――――――――――――――――――")

(exemplify-ert fj-test-string-number>
  (fj-string-number> "34" "12") => t
  (fj-string-number> "12" "34") => nil
  (fj-string-number> "12" "12" #'>=) => t)

;; TODO: tests for timeline items
