;;; checkdoc-config.el --- Configuration for running checkdoc -*- lexical-binding: t; -*-

;; This file is part of Proof General.

;; The software is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;;; Code:

(defvar checkdoc-package-keywords-flag)
(defvar checkdoc-spellcheck-documentation-flag)
(defvar checkdoc-ispell-lisp-words)

(with-eval-after-load "checkdoc"

  ;; Output file names relative to the root directory
  (advice-add 'checkdoc-buffer-label :around
              (lambda (fun)
                (let ((default-directory (locate-dominating-file default-directory ".git")))
                  (funcall fun))))

  ;; Things to fix eventually
  (setq checkdoc-force-docstrings-flag nil)
  (setq checkdoc--interactive-docstring-flag nil)
  (setq checkdoc-arguments-missing-flag nil)

  (setq checkdoc-package-keywords-flag t)
  (setq checkdoc-spellcheck-documentation-flag t)
  (setq checkdoc-ispell-lisp-words

        '(;; default value of `checkdoc-ispell-lisp-words'
          "alist" "emacs" "etags" "keymap"  "paren" "regexp" "sexp"

          "BackTo"
          "CompCert"
          "CoqProject"
          "EasyCrypt"
          "Imenu"
          "LoadPath"
          "PROJECT's"
          "Phox"
          "ProofGeneral"
          "Qed"
          "RightClick"
          "Rocq"
          "RocqProject"
          "SComint"
          "Toplevel"
          "UTF"
          "aN"
          "addids"
          "alreadyopen"
          "analyse"
          "analysed"
          "arg"
          "args"
          "askids"
          "askpgip"
          "askprefs"
          "async"
          "autodetected"
          "autosend"
          "backend"
          "basename"
          "beghypname"
          "behaviour"
          "bigjobs"
          "browsable"
          "buf"
          "bufhist"
          "canonicalized"
          "cbv"
          "cmd"
          "colour"
          "coloured"
          "colouring"
          "comint"
          "concl"
          "config"
          "containt"
          "coq"
          "coqc"
          "coqdep"
          "coqtop"
          "ctrl"
          "curlies"
          "customizable"
          "customizations"
          "cygwin"
          "deffn"
          "defopt"
          "defs"
          "delids"
          "dep"
          "dependee"
          "dependees"
          "descr"
          "desynchronized"
          "dir"
          "docstring"
          "docstrings"
          "el"
          "elisp"
          "elts"
          "endhypname"
          "env"
          "eval"
          "evar"
          "evars"
          "exe"
          "exec'd"
          "existentials"
          "facename"
          "favourite"
          "favourites"
          "filestatus"
          "fixpoint"
          "floatset"
          "fontify"
          "fontifying"
          "fontset"
          "fontsets"
          "forall"
          "fraktur"
          "github"
          "glyphs"
          "goalsave"
          "goto"
          "haspref"
          "holes's"
          "https"
          "hyp"
          "hypcrossov"
          "hypname"
          "hypnameov"
          "hyps"
          "ident"
          "idn"
          "idtables"
          "ifb"
          "iff"
          "infoH"
          "infos"
          "init"
          "initialise"
          "initialised"
          "initialises"
          "instantiation"
          "instantiations"
          "intitalizes"
          "ints"
          "intset"
          "invariants"
          "isar"
          "iteratively"
          "ith"
          "keydef"
          "keymaps"
          "loopbacks"
          "lpat"
          "ltac"
          "makefile"
          "massb"
          "matcher"
          "maths"
          "minibuffer"
          "modeline"
          "monadic"
          "munge"
          "myassert"
          "mytac"
          "nat"
          "nd"
          "newfile"
          "nonrecursive"
          "opam"
          "pbp"
          "pbrpm"
          "personalization"
          "pgdynamic"
          "pggroup"
          "pgip"
          "pgipgcmd"
          "pgiptype"
          "pico"
          "plist"
          "pos"
          "pre"
          "precomputed"
          "prepended"
          "prev"
          "prog"
          "proofer"
          "proofstart"
          "proofstate"
          "prooftree"
          "prover"
          "prover's"
          "proverid"
          "provers"
          "ptys"
          "qRHL"
          "qed"
          "qualid"
          "recompilations"
          "recureses"
          "recurse"
          "redisplayed"
          "rehighlight"
          "rehighlighted"
          "reinitialise"
          "reparse"
          "resynchronised"
          "rpat"
          "savegoal"
          "sequent"
          "serie"
          "setids"
          "sexp"
          "sexps"
          "smie"
          "src"
          "srcid"
          "srcrds"
          "standardly"
          "stderr"
          "stdout"
          "stepwise"
          "stm"
          "str"
          "struct"
          "subdirectory"
          "subexpr"
          "subexpressions"
          "subgoal"
          "subgoals"
          "sublist"
          "submenu"
          "submenus"
          "substring"
          "substrings"
          "subterm"
          "subtree"
          "symb"
          "tac"
          "tacticals"
          "texi"
          "thm"
          "tokenised"
          "toolchain"
          "tooltip"
          "tooltips"
          "topfile"
          "truename"
          "unadjusted"
          "unclosed"
          "undoable"
          "undos"
          "unfocusing"
          "unfontify"
          "unhighlight"
          "uninstantiated"
          "uninterned"
          "unsets"
          "util"
          "vio"
          "vo"
          "vok"
          "vos"
          "wellformedness"
          "whitespace"
          "yas"
          "yasnippet"
          "yasnippets"
          "xml")))

(provide 'checkdoc-config)

;;; checkdoc-config.el ends here
